/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer;

import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.context.PolarisSDKContextManager;
import com.tencent.cloud.polaris.loadbalancer.PolarisRingHashLoadBalancer;
import com.tencent.cloud.polaris.loadbalancer.PolarisServiceInstanceListSupplier;
import com.tencent.cloud.polaris.loadbalancer.PolarisWeightedRandomLoadBalancer;
import com.tencent.cloud.polaris.loadbalancer.PolarisWeightedRoundRobinLoadBalancer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.ConditionalOnBlockingDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.ConditionalOnReactiveDiscoveryEnabled;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.loadbalancer.core.RandomLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ReactorLoadBalancer;
import org.springframework.cloud.loadbalancer.core.RoundRobinLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisEnabled
@ConditionalOnDiscoveryEnabled
public class PolarisLoadBalancerClientConfiguration {
    private static final int REACTIVE_SERVICE_INSTANCE_SUPPLIER_ORDER = 193827465;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.polaris.loadbalancer.strategy"}, havingValue="roundRobin", matchIfMissing=true)
    public ReactorLoadBalancer<ServiceInstance> roundRobinLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new RoundRobinLoadBalancer(loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.polaris.loadbalancer.strategy"}, havingValue="random")
    public ReactorLoadBalancer<ServiceInstance> randomLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new RandomLoadBalancer(loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), name);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.polaris.loadbalancer.strategy"}, havingValue="polarisWeightedRandom")
    public ReactorLoadBalancer<ServiceInstance> polarisWeightedLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, PolarisSDKContextManager polarisSDKContextManager) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new PolarisWeightedRandomLoadBalancer(name, (ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), polarisSDKContextManager.getRouterAPI());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.polaris.loadbalancer.strategy"}, havingValue="polarisRingHash")
    public ReactorLoadBalancer<ServiceInstance> polarisRingHashLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, PolarisSDKContextManager polarisSDKContextManager) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new PolarisRingHashLoadBalancer(name, (ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), polarisSDKContextManager.getRouterAPI());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.polaris.loadbalancer.strategy"}, havingValue="polarisWeightedRoundRobin")
    public ReactorLoadBalancer<ServiceInstance> polarisWeightedRoundRobinLoadBalancer(Environment environment, LoadBalancerClientFactory loadBalancerClientFactory, PolarisSDKContextManager polarisSDKContextManager) {
        String name = environment.getProperty("loadbalancer.client.name");
        return new PolarisWeightedRoundRobinLoadBalancer(name, (ObjectProvider<ServiceInstanceListSupplier>)loadBalancerClientFactory.getLazyProvider(name, ServiceInstanceListSupplier.class), polarisSDKContextManager.getRouterAPI());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBlockingDiscoveryEnabled
    @Order(value=193827466)
    protected static class PolarisBlockingSupportConfiguration {
        protected PolarisBlockingSupportConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={DiscoveryClient.class})
        public ServiceInstanceListSupplier polarisRouterDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new PolarisServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withBlockingDiscoveryClient().build(context));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnReactiveDiscoveryEnabled
    @Order(value=193827465)
    protected static class PolarisReactiveSupportConfiguration {
        protected PolarisReactiveSupportConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={ReactiveDiscoveryClient.class})
        public ServiceInstanceListSupplier polarisRouterDiscoveryClientServiceInstanceListSupplier(ConfigurableApplicationContext context) {
            return new PolarisServiceInstanceListSupplier(ServiceInstanceListSupplier.builder().withDiscoveryClient().build(context));
        }
    }
}

