/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.loadbalancer;

import com.tencent.cloud.polaris.context.ConditionalOnPolarisEnabled;
import com.tencent.cloud.polaris.loadbalancer.PolarisLoadBalancerClientConfiguration;
import com.tencent.cloud.rpc.enhancement.resttemplate.EnhancedRestTemplateInterceptor;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.cloud.client.loadbalancer.RetryLoadBalancerInterceptor;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClients;
import org.springframework.cloud.loadbalancer.config.LoadBalancerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.util.CollectionUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnDiscoveryEnabled
@ConditionalOnPolarisEnabled
@ConditionalOnProperty(value={"spring.cloud.polaris.loadbalancer.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={LoadBalancerAutoConfiguration.class})
@LoadBalancerClients(defaultConfiguration={PolarisLoadBalancerClientConfiguration.class})
public class PolarisLoadBalancerAutoConfiguration {
    @Bean
    public RestTemplateCustomizer polarisRestTemplateCustomizer(@Autowired(required=false) RetryLoadBalancerInterceptor retryLoadBalancerInterceptor, @Autowired(required=false) LoadBalancerInterceptor loadBalancerInterceptor) {
        return restTemplate -> {
            ArrayList<Object> list = new ArrayList<Object>(restTemplate.getInterceptors());
            int addIndex = list.size();
            if (CollectionUtils.containsInstance(list, (Object)retryLoadBalancerInterceptor) || CollectionUtils.containsInstance(list, (Object)loadBalancerInterceptor)) {
                ClientHttpRequestInterceptor enhancedRestTemplateInterceptor = null;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EnhancedRestTemplateInterceptor)) continue;
                    enhancedRestTemplateInterceptor = (ClientHttpRequestInterceptor)list.get(i);
                    addIndex = i;
                }
                if (enhancedRestTemplateInterceptor != null) {
                    list.remove(addIndex);
                    list.add(enhancedRestTemplateInterceptor);
                }
            } else if (retryLoadBalancerInterceptor != null || loadBalancerInterceptor != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof EnhancedRestTemplateInterceptor)) continue;
                    addIndex = i;
                }
                list.add(addIndex, retryLoadBalancerInterceptor != null ? retryLoadBalancerInterceptor : loadBalancerInterceptor);
            }
            restTemplate.setInterceptors(list);
        };
    }
}

