/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.discovery;

import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.context.PolarisSDKContextManager;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.GetHealthyInstancesRequest;
import com.tencent.polaris.api.rpc.GetServicesRequest;
import com.tencent.polaris.api.rpc.InstancesResponse;
import com.tencent.polaris.api.rpc.ServicesResponse;

public class PolarisDiscoveryHandler {
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;
    private final ConsumerAPI polarisConsumer;

    public PolarisDiscoveryHandler(PolarisDiscoveryProperties polarisDiscoveryProperties, PolarisSDKContextManager polarisSDKContextManager) {
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
        this.polarisConsumer = polarisSDKContextManager.getConsumerAPI();
    }

    public InstancesResponse getHealthyInstances(String service) {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetHealthyInstancesRequest getHealthyInstancesRequest = new GetHealthyInstancesRequest();
        getHealthyInstancesRequest.setNamespace(namespace);
        getHealthyInstancesRequest.setService(service);
        getHealthyInstancesRequest.setIncludeCircuitBreakInstances(Boolean.valueOf(false));
        return this.polarisConsumer.getHealthyInstances(getHealthyInstancesRequest);
    }

    public InstancesResponse getInstances(String service) {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetAllInstancesRequest request = new GetAllInstancesRequest();
        request.setNamespace(namespace);
        request.setService(service);
        return this.polarisConsumer.getAllInstances(request);
    }

    public ServicesResponse getServices() {
        String namespace = this.polarisDiscoveryProperties.getNamespace();
        GetServicesRequest request = new GetServicesRequest();
        request.setNamespace(namespace);
        return this.polarisConsumer.getServices(request);
    }
}

