/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris;

import com.tencent.cloud.common.constant.OrderConstant;
import com.tencent.cloud.polaris.PolarisDiscoveryProperties;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.consumer.DiscoveryConfigImpl;
import com.tencent.polaris.factory.config.provider.RegisterConfigImpl;

public class PolarisDiscoveryConfigModifier
implements PolarisConfigModifier {
    private static final String ID = "polaris";
    private final PolarisDiscoveryProperties polarisDiscoveryProperties;

    public PolarisDiscoveryConfigModifier(PolarisDiscoveryProperties polarisDiscoveryProperties) {
        this.polarisDiscoveryProperties = polarisDiscoveryProperties;
    }

    public void modify(ConfigurationImpl configuration) {
        if (this.polarisDiscoveryProperties != null) {
            DiscoveryConfigImpl discoveryConfig = new DiscoveryConfigImpl();
            discoveryConfig.setServerConnectorId(ID);
            discoveryConfig.setEnable(this.polarisDiscoveryProperties.isEnabled());
            configuration.getConsumer().getDiscoveries().add(discoveryConfig);
            RegisterConfigImpl registerConfig = new RegisterConfigImpl();
            registerConfig.setServerConnectorId(ID);
            registerConfig.setEnable(this.polarisDiscoveryProperties.isRegisterEnabled());
            configuration.getProvider().getRegisters().add(registerConfig);
        }
    }

    public int getOrder() {
        return OrderConstant.Modifier.DISCOVERY_CONFIG_ORDER;
    }
}

