/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.CompletableFutureTimeout;
import com.taosdata.jdbc.utils.StringUtils;
import com.taosdata.jdbc.utils.Utils;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.WSClient;
import com.taosdata.jdbc.ws.WSConnection;
import com.taosdata.jdbc.ws.WebsocketNotConnectedException;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.CommonResp;
import com.taosdata.jdbc.ws.entity.ConnectReq;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transport
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(Transport.class);
    private static final boolean isTest = "test".equalsIgnoreCase(System.getProperty("ENV_TAOS_JDBC_TEST"));
    public static final int DEFAULT_MESSAGE_WAIT_TIMEOUT = 60000;
    public static final int TSDB_CODE_RPC_NETWORK_UNAVAIL = 11;
    public static final int TSDB_CODE_RPC_SOMENODE_NOT_CONNECTED = 32;
    private final AtomicInteger reconnectCount = new AtomicInteger(0);
    private final ArrayList<WSClient> clientArr = new ArrayList();
    private final InFlightRequest inFlightRequest;
    private long timeout;
    private volatile boolean closed = false;
    private final ConnectionParam connectionParam;
    private final WSFunction wsFunction;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private int currentNodeIndex;

    protected Transport() {
        this.inFlightRequest = null;
        this.connectionParam = null;
        this.wsFunction = null;
    }

    public Transport(WSFunction function, ConnectionParam param, InFlightRequest inFlightRequest) throws SQLException {
        WSClient slave = WSClient.getSlaveInstance(param, function, this);
        if (slave != null) {
            WSClient master = WSClient.getInstance(param, 0, function, this);
            this.clientArr.add(master);
            this.clientArr.add(slave);
            this.currentNodeIndex = 0;
        } else {
            if (!isTest) {
                Collections.shuffle(param.getEndpoints());
            }
            for (int i = 0; i < param.getEndpoints().size(); ++i) {
                WSClient client = WSClient.getInstance(param, i, function, this);
                this.clientArr.add(client);
            }
            this.currentNodeIndex = 0;
        }
        this.inFlightRequest = inFlightRequest;
        this.connectionParam = param;
        this.wsFunction = function;
        this.setTimeout(param.getRequestTimeout());
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            timeout = 60000L;
        } else if (timeout == 0L) {
            timeout = Integer.MAX_VALUE;
        }
        this.timeout = timeout;
    }

    private void reconnect(boolean isTmq) throws SQLException {
        Transport transport = this;
        synchronized (transport) {
            if (this.isConnected()) {
                return;
            }
            for (int i = 0; i < this.clientArr.size() && this.connectionParam.isEnableAutoConnect(); ++i) {
                boolean reconnected = this.reconnectCurNode(isTmq);
                if (reconnected) {
                    this.reconnectCount.incrementAndGet();
                    log.debug("reconnect success to {}", (Object)StringUtils.getBasicUrl(this.clientArr.get((int)this.currentNodeIndex).serverUri.toString()));
                    return;
                }
                log.debug("reconnect failed to {}", (Object)StringUtils.getBasicUrl(this.clientArr.get((int)this.currentNodeIndex).serverUri.toString()));
                this.currentNodeIndex = (this.currentNodeIndex + 1) % this.clientArr.size();
            }
            this.close();
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
    }

    private void tmqRethrowConnectionCloseException() throws SQLException {
        if (WSFunction.TMQ.equals((Object)this.wsFunction)) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
    }

    public Response send(Request request) throws SQLException {
        return this.send(request, true);
    }

    public Response send(Request request, boolean reSend) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        Response response = null;
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        String reqString = request.toString();
        try {
            this.inFlightRequest.put(new FutureResponse(request.getAction(), request.id(), completableFuture));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new SQLException(e);
        }
        try {
            this.clientArr.get(this.currentNodeIndex).send(reqString);
        }
        catch (WebsocketNotConnectedException e) {
            this.tmqRethrowConnectionCloseException();
            this.reconnect(false);
            try {
                if (!reSend) {
                    this.inFlightRequest.remove(request.getAction(), request.id());
                    throw new SQLException("reconnect, need to resend " + request.getAction() + " msg");
                }
                this.clientArr.get(this.currentNodeIndex).send(reqString);
            }
            catch (Exception ex) {
                this.inFlightRequest.remove(request.getAction(), request.id());
                throw TSDBError.createSQLException(8984, e.getMessage());
            }
        }
        CompletableFuture<Response> responseFuture = CompletableFutureTimeout.orTimeout(completableFuture, this.timeout, TimeUnit.MILLISECONDS, reqString);
        try {
            response = responseFuture.get();
            this.handleErrInMasterSlaveMode(response);
        }
        catch (InterruptedException | ExecutionException e) {
            this.inFlightRequest.remove(request.getAction(), request.id());
            throw TSDBError.createSQLException(8990, e.getMessage());
        }
        return response;
    }

    public Response send(String action, long reqId, long resultId, long type, byte[] rawData) throws SQLException {
        return this.send(action, reqId, resultId, type, rawData, EMPTY_BYTE_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(String action, long reqId, long resultId, long type, byte[] rawData, byte[] rawData2) throws SQLException {
        Response response;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        int totalLength = 24 + rawData.length + rawData2.length;
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(totalLength);
        buffer.writeLongLE(reqId);
        buffer.writeLongLE(resultId);
        buffer.writeLongLE(type);
        buffer.writeBytes(rawData);
        buffer.writeBytes(rawData2);
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        try {
            this.inFlightRequest.put(new FutureResponse(action, reqId, completableFuture));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new SQLException(e);
        }
        try {
            Utils.retainByteBuf(buffer);
            this.clientArr.get(this.currentNodeIndex).send(buffer);
        }
        catch (WebsocketNotConnectedException e) {
            this.tmqRethrowConnectionCloseException();
            this.reconnect(false);
            try {
                Utils.retainByteBuf(buffer);
                this.clientArr.get(this.currentNodeIndex).send(buffer);
            }
            catch (Exception ex) {
                this.inFlightRequest.remove(action, reqId);
                throw TSDBError.createSQLException(8984, e.getMessage());
            }
        }
        finally {
            Utils.releaseByteBuf(buffer);
        }
        String reqString = "action:" + action + ", reqId:" + reqId + ", resultId:" + resultId + ", actionType" + type;
        CompletableFuture<Response> responseFuture = CompletableFutureTimeout.orTimeout(completableFuture, this.timeout, TimeUnit.MILLISECONDS, reqString);
        try {
            response = responseFuture.get();
            this.handleErrInMasterSlaveMode(response);
        }
        catch (InterruptedException | ExecutionException e) {
            this.inFlightRequest.remove(action, reqId);
            throw TSDBError.createSQLException(8990, e.getMessage());
        }
        return response;
    }

    public void sendFetchBlockAsync(long reqId, long resultId) throws SQLException {
        byte[] version = new byte[]{1, 0};
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        int totalLength = 26;
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(totalLength);
        buffer.writeLongLE(reqId);
        buffer.writeLongLE(resultId);
        buffer.writeLongLE(7L);
        buffer.writeBytes(version);
        try {
            Utils.retainByteBuf(buffer);
            this.clientArr.get(this.currentNodeIndex).send(buffer);
        }
        catch (WebsocketNotConnectedException e) {
            this.reconnect(false);
            throw TSDBError.createSQLException(8964, "Websocket reconnected, but the result set is closed");
        }
        finally {
            Utils.releaseByteBuf(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response send(String action, long reqId, ByteBuf buffer, boolean resend) throws SQLException {
        Response response;
        if (this.isClosed()) {
            Utils.releaseByteBuf(buffer);
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        try {
            this.inFlightRequest.put(new FutureResponse(action, reqId, completableFuture));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new SQLException(e);
        }
        try {
            Utils.retainByteBuf(buffer);
            this.clientArr.get(this.currentNodeIndex).send(buffer);
        }
        catch (WebsocketNotConnectedException e) {
            this.tmqRethrowConnectionCloseException();
            this.reconnect(false);
            try {
                Utils.retainByteBuf(buffer);
                if (!resend) {
                    this.inFlightRequest.remove(action, reqId);
                    throw new SQLException("reconnect, need to resend " + action + " msg");
                }
                this.clientArr.get(this.currentNodeIndex).send(buffer);
            }
            catch (Exception ex) {
                this.inFlightRequest.remove(action, reqId);
                throw TSDBError.createSQLException(8984, ex.getMessage());
            }
            Utils.releaseByteBuf(buffer);
        }
        finally {
            Utils.releaseByteBuf(buffer);
        }
        String reqString = "action:" + action + ", reqId:" + reqId;
        CompletableFuture<Response> responseFuture = CompletableFutureTimeout.orTimeout(completableFuture, this.timeout, TimeUnit.MILLISECONDS, reqString);
        try {
            response = responseFuture.get();
            this.handleErrInMasterSlaveMode(response);
        }
        catch (InterruptedException | ExecutionException e) {
            this.inFlightRequest.remove(action, reqId);
            throw TSDBError.createSQLException(8990, e.getMessage());
        }
        return response;
    }

    private void handleErrInMasterSlaveMode(Response response) throws InterruptedException {
        CommonResp commonResp;
        if (this.clientArr.size() > 1 && response instanceof CommonResp && (11 == (commonResp = (CommonResp)response).getCode() || 32 == commonResp.getCode())) {
            this.clientArr.get(this.currentNodeIndex).closeBlocking();
        }
    }

    public Response sendWithoutRetry(Request request) throws SQLException {
        Response response;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        CompletableFuture<Response> completableFuture = new CompletableFuture<Response>();
        String reqString = request.toString();
        try {
            this.inFlightRequest.put(new FutureResponse(request.getAction(), request.id(), completableFuture));
        }
        catch (InterruptedException | TimeoutException e) {
            throw new SQLException(e);
        }
        try {
            this.clientArr.get(this.currentNodeIndex).send(reqString);
        }
        catch (Exception e) {
            this.inFlightRequest.remove(request.getAction(), request.id());
            throw TSDBError.createSQLException(8984, e.getMessage() == null ? "" : e.getMessage());
        }
        CompletableFuture<Response> responseFuture = CompletableFutureTimeout.orTimeout(completableFuture, this.timeout, TimeUnit.MILLISECONDS, reqString);
        try {
            response = responseFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.inFlightRequest.remove(request.getAction(), request.id());
            throw TSDBError.createSQLException(8990, e.getMessage());
        }
        return response;
    }

    public void sendWithoutResponse(Request request) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961, "Websocket Not Connected Exception");
        }
        try {
            this.clientArr.get(this.currentNodeIndex).send(request.toString());
        }
        catch (WebsocketNotConnectedException e) {
            this.tmqRethrowConnectionCloseException();
            this.reconnect(false);
            try {
                this.clientArr.get(this.currentNodeIndex).send(request.toString());
            }
            catch (Exception ex) {
                throw TSDBError.createSQLException(8984, e.getMessage());
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConnectionLost() {
        return this.clientArr.get(this.currentNodeIndex).isClosed();
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.inFlightRequest.close();
        for (WSClient wsClient : this.clientArr) {
            wsClient.close();
        }
    }

    public void checkConnection(int connectTimeout) throws SQLException {
        if (WSConnection.g_FirstConnection.compareAndSet(true, false) && !StringUtils.isEmpty(this.connectionParam.getSlaveClusterHost())) {
            for (WSClient wsClient : this.clientArr) {
                if (!wsClient.connectBlocking()) {
                    this.close();
                    throw TSDBError.createSQLException(8989, "can't create connection with server " + wsClient.serverUri.toString() + " within: " + connectTimeout + " milliseconds");
                }
                log.debug("connect success to {}", (Object)StringUtils.getBasicUrl(wsClient.serverUri.toString()));
            }
            for (int i = 0; i < this.clientArr.size(); ++i) {
                if (i == this.currentNodeIndex) continue;
                this.clientArr.get(i).closeBlocking();
                log.debug("disconnect success to {}", (Object)StringUtils.getBasicUrl(this.clientArr.get((int)i).serverUri.toString()));
            }
        } else {
            for (int i = 0; i < this.clientArr.size(); ++i) {
                this.currentNodeIndex %= this.clientArr.size();
                if (this.clientArr.get(this.currentNodeIndex).connectBlocking()) {
                    log.debug("connect success to {}", (Object)StringUtils.getBasicUrl(this.clientArr.get((int)this.currentNodeIndex).serverUri.toString()));
                    return;
                }
                this.currentNodeIndex = (this.currentNodeIndex + 1) % this.clientArr.size();
            }
            this.close();
            throw TSDBError.createSQLException(8989, "can't create connection with any server within: " + connectTimeout + " milliseconds");
        }
    }

    public void shutdown() {
        this.closed = true;
        if (this.inFlightRequest.hasInFlightRequest()) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    TimeUnit.MILLISECONDS.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            future.thenRun(this::close);
        } else {
            this.close();
        }
    }

    public void reconnectTmq() throws SQLException {
        this.reconnect(true);
    }

    private boolean reconnectCurNode(boolean isTmq) throws SQLException {
        for (int retryTimes = 0; retryTimes < this.connectionParam.getReconnectRetryCount(); ++retryTimes) {
            try {
                boolean reconnected = this.clientArr.get(this.currentNodeIndex).reconnectBlocking();
                if (reconnected) {
                    if (isTmq) {
                        return true;
                    }
                    ConnectReq connectReq = new ConnectReq(this.connectionParam);
                    ConnectResp auth = (ConnectResp)this.sendWithoutRetry(new Request(Action.CONN.getAction(), connectReq));
                    if (Code.SUCCESS.getCode() == auth.getCode()) {
                        return true;
                    }
                    this.clientArr.get(this.currentNodeIndex).closeBlocking();
                    log.error("reconnect failed, code: {}, msg: {}", (Object)auth.getCode(), (Object)auth.getMessage());
                }
                Thread.sleep(this.connectionParam.getReconnectIntervalMs());
                continue;
            }
            catch (Exception e) {
                log.error("try connect remote server failed!", (Throwable)e);
            }
        }
        return false;
    }

    public int getReconnectCount() {
        return this.reconnectCount.get();
    }

    public boolean isConnected() {
        return this.clientArr.get(this.currentNodeIndex).isOpen();
    }

    public final ConnectionParam getConnectionParam() {
        return this.connectionParam;
    }
}

