/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.common.TDBlob;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.utils.DataTypeConverUtil;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.ws.AbstractWSResultSet;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.QueryResp;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.List;

public class BlockResultSet
extends AbstractWSResultSet {
    private final ZoneId zoneId;
    private final boolean varcharAsString;

    public BlockResultSet(Statement statement, Transport transport, QueryResp response, String database, ZoneId zoneId) throws SQLException {
        super(statement, transport, response, database);
        this.zoneId = zoneId;
        this.varcharAsString = transport.getConnectionParam().isVarcharAsString();
    }

    public Object parseValue(int columnIndex) throws SQLException {
        Object source = ((List)this.result.get(columnIndex - 1)).get(this.rowIndex);
        if (null == source) {
            return null;
        }
        int type = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.parseValue(type, source, this.varcharAsString);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Instant) {
            return DateTimeUtils.getTimestamp((Instant)value, this.zoneId).toString();
        }
        if (value instanceof byte[]) {
            String charset = StandardCharsets.UTF_8.name();
            try {
                return new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return value.toString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return false;
        }
        this.wasNull = false;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.getBoolean(taosType, value);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Byte) {
            return (Byte)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.getByte(taosType, value, columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Short) {
            return (Short)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.getShort(taosType, value, columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Integer) {
            return (Integer)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.getInt(taosType, value, columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0L;
        }
        this.wasNull = false;
        if (value instanceof Long) {
            return (Long)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.getLong(taosType, value, columnIndex, this.timestampPrecision);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0.0f;
        }
        this.wasNull = false;
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.getFloat(taosType, value, columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0.0;
        }
        this.wasNull = false;
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.getDouble(taosType, value, columnIndex, this.timestampPrecision);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return DataTypeConverUtil.getBytes(value);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return DataTypeConverUtil.getDate(value, this.zoneId);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return DataTypeConverUtil.getTime(value, this.zoneId);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp ret;
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof Instant) {
            return DateTimeUtils.getTimestamp((Instant)value, this.zoneId);
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Long) {
            Instant instant = DateTimeUtils.parseTimestampColumnData((Long)value, this.timestampPrecision);
            return DateTimeUtils.getTimestamp(instant, this.zoneId);
        }
        String tmp = "";
        if (value instanceof byte[]) {
            String charset = TaosGlobalConfig.getCharset();
            try {
                tmp = new String((byte[])value, charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        } else {
            tmp = value.toString();
        }
        try {
            ret = DateTimeUtils.parseTimestamp(tmp, this.zoneId);
        }
        catch (Exception e) {
            ret = null;
            this.wasNull = true;
        }
        return ret;
    }

    private Object getObjectInternal(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object value = this.getObjectInternal(columnIndex);
        if (value instanceof Instant) {
            return DateTimeUtils.getTimestamp((Instant)value, this.zoneId);
        }
        if (((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType() == 18) {
            return new TDBlob((byte[])value, true);
        }
        return value;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        Object value = this.getObjectInternal(columnIndex);
        if (value == null) {
            return null;
        }
        return new TDBlob((byte[])value, true);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Object value = this.getObjectInternal(columnIndex);
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        try {
            if (type == String.class) {
                if (value instanceof byte[]) {
                    String charset = StandardCharsets.UTF_8.name();
                    return type.cast(new String((byte[])value, charset));
                }
                return type.cast(value.toString());
            }
            if (type == Integer.class && value instanceof Number) {
                return type.cast(((Number)value).intValue());
            }
            if (type == Long.class && value instanceof Number) {
                return type.cast(((Number)value).longValue());
            }
            if (type == Short.class && value instanceof Number) {
                return type.cast(((Number)value).shortValue());
            }
            if (type == Double.class && value instanceof Number) {
                return type.cast(((Number)value).doubleValue());
            }
            if (type == Float.class && value instanceof Number) {
                return type.cast(Float.valueOf(((Number)value).floatValue()));
            }
            if (type == BigDecimal.class && value instanceof Number) {
                return type.cast(new BigDecimal(value.toString()));
            }
            if (type == BigInteger.class && value instanceof Number) {
                return type.cast(new BigInteger(value.toString()));
            }
            if (type == Byte.class && value instanceof Number) {
                return type.cast(((Number)value).byteValue());
            }
            if (type == LocalDateTime.class && value instanceof Instant) {
                Instant instant = (Instant)value;
                return type.cast(DateTimeUtils.getLocalDateTime(instant, this.zoneId));
            }
            if (type == OffsetDateTime.class && value instanceof Instant) {
                Instant instant = (Instant)value;
                return type.cast(DateTimeUtils.getOffsetDateTime(instant, this.zoneId));
            }
            if (type == ZonedDateTime.class && value instanceof Instant) {
                Instant instant = (Instant)value;
                return type.cast(DateTimeUtils.getZonedDateTime(instant, this.zoneId));
            }
            if (type == Blob.class && value instanceof byte[]) {
                return type.cast(new TDBlob((byte[])value, true));
            }
            throw TSDBError.createSQLException(8992, "Cannot convert " + value.getClass() + " to " + type);
        }
        catch (UnsupportedEncodingException | ClassCastException e) {
            throw TSDBError.createSQLException(8992, "faild to convert " + value.getClass() + " to " + type);
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        int columnIndex = this.columnNames.indexOf(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("cannot find Column in result");
        }
        return columnIndex + 1;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        int taosType = ((RestfulResultSet.Field)this.fields.get(columnIndex - 1)).getTaosType();
        return DataTypeConverUtil.getBigDecimal(taosType, value);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex == -1 && this.numOfRows != 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex >= this.numOfRows && this.numOfRows != 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        return this.rowIndex == this.numOfRows - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            if (this.numOfRows > 0) {
                this.rowIndex = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            if (this.numOfRows > 0) {
                this.rowIndex = this.numOfRows;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            this.rowIndex = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            this.rowIndex = this.numOfRows - 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int row;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        BlockResultSet blockResultSet = this;
        synchronized (blockResultSet) {
            if (this.rowIndex < 0 || this.rowIndex >= this.numOfRows) {
                return 0;
            }
            row = this.rowIndex + 1;
        }
        return row;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.statement;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }
}

