/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws.tmq;

import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulResultSet;
import com.taosdata.jdbc.rs.RestfulResultSetMetaData;
import com.taosdata.jdbc.utils.DataTypeConverUtil;
import com.taosdata.jdbc.utils.DateTimeUtils;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.tmq.entity.FetchRawBlockResp;
import com.taosdata.jdbc.ws.tmq.entity.TMQRequestFactory;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class WSConsumerResultSet
extends AbstractResultSet {
    private final Transport transport;
    private final TMQRequestFactory factory;
    private final long messageId;
    private final String database;
    protected volatile boolean isClosed;
    protected RestfulResultSetMetaData metaData;
    protected final List<RestfulResultSet.Field> fields = new ArrayList<RestfulResultSet.Field>();
    protected List<String> columnNames;
    protected List<List<Object>> result = new ArrayList<List<Object>>();
    protected int numOfRows = 0;
    protected int rowIndex = 0;

    public WSConsumerResultSet(Transport transport, TMQRequestFactory factory, long messageId, String database) {
        this.transport = transport;
        this.factory = factory;
        this.messageId = messageId;
        this.database = database;
    }

    private boolean forward() {
        if (this.rowIndex > this.numOfRows) {
            return false;
        }
        return ++this.rowIndex < this.numOfRows;
    }

    public void reset() {
        this.rowIndex = 0;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.forward()) {
            return true;
        }
        if (this.numOfRows > 0) {
            return false;
        }
        Request request = this.factory.generateFetchRaw(this.messageId);
        FetchRawBlockResp fetchResp = (FetchRawBlockResp)this.transport.send(request);
        fetchResp.init();
        if (Code.SUCCESS.getCode() != fetchResp.getCode()) {
            throw TSDBError.createSQLException(fetchResp.getCode(), fetchResp.getMessage());
        }
        fetchResp.parseBlockInfos();
        this.reset();
        if (fetchResp.getRows() == 0) {
            return false;
        }
        this.columnNames = fetchResp.getColumnNames();
        this.fields.clear();
        this.fields.addAll(fetchResp.getFields());
        this.metaData = new RestfulResultSetMetaData(this.database, this.fields, fetchResp.getTableName());
        this.numOfRows = fetchResp.getRows();
        this.result = fetchResp.getResultData();
        this.timestampPrecision = fetchResp.getPrecision();
        return true;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return DataTypeConverUtil.getString(value);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return false;
        }
        this.wasNull = false;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        int taosType = this.fields.get(columnIndex - 1).getTaosType();
        return DataTypeConverUtil.getBoolean(taosType, value);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Byte) {
            return (Byte)value;
        }
        int taosType = this.fields.get(columnIndex - 1).getTaosType();
        return DataTypeConverUtil.getByte(taosType, value, columnIndex);
    }

    private void throwRangeException(String valueAsString, int columnIndex, int jdbcType) throws SQLException {
        throw TSDBError.createSQLException(8980, "'" + valueAsString + "' in column '" + columnIndex + "' is outside valid range for the jdbcType " + TSDBConstants.jdbcType2TaosTypeName(jdbcType));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Short) {
            return (Short)value;
        }
        int taosType = this.fields.get(columnIndex - 1).getTaosType();
        return DataTypeConverUtil.getShort(taosType, value, columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0;
        }
        this.wasNull = false;
        if (value instanceof Integer) {
            return (Integer)value;
        }
        int taosType = this.fields.get(columnIndex - 1).getTaosType();
        return DataTypeConverUtil.getInt(taosType, value, columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0L;
        }
        this.wasNull = false;
        if (value instanceof Long) {
            return (Long)value;
        }
        int taosType = this.fields.get(columnIndex - 1).getTaosType();
        return DataTypeConverUtil.getLong(taosType, value, columnIndex, this.timestampPrecision);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0.0f;
        }
        this.wasNull = false;
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        int taosType = this.fields.get(columnIndex - 1).getTaosType();
        return DataTypeConverUtil.getFloat(taosType, value, columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return 0.0;
        }
        this.wasNull = false;
        int taosType = this.fields.get(columnIndex - 1).getTaosType();
        return DataTypeConverUtil.getDouble(taosType, value, columnIndex, this.timestampPrecision);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return DataTypeConverUtil.getBytes(value);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp ret;
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Long) {
            Instant instant = DateTimeUtils.parseTimestampColumnData((Long)value, this.timestampPrecision);
            return DateTimeUtils.getTimestamp(instant, null);
        }
        try {
            ret = DateTimeUtils.parseTimestamp(value.toString(), null);
        }
        catch (Exception e) {
            ret = null;
            this.wasNull = true;
        }
        return ret;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        int columnIndex = this.columnNames.indexOf(columnLabel);
        if (columnIndex == -1) {
            throw new SQLException("cannot find Column in result");
        }
        return columnIndex + 1;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkAvailability(columnIndex, this.fields.size());
        Object value = this.parseValue(columnIndex);
        if (value == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        int taosType = this.fields.get(columnIndex - 1).getTaosType();
        return DataTypeConverUtil.getBigDecimal(taosType, value);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex == -1 && this.numOfRows != 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex >= this.numOfRows && this.numOfRows != 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.rowIndex == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        return this.rowIndex == this.numOfRows - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        WSConsumerResultSet wSConsumerResultSet = this;
        synchronized (wSConsumerResultSet) {
            if (this.numOfRows > 0) {
                this.rowIndex = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        WSConsumerResultSet wSConsumerResultSet = this;
        synchronized (wSConsumerResultSet) {
            if (this.numOfRows > 0) {
                this.rowIndex = this.numOfRows;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        WSConsumerResultSet wSConsumerResultSet = this;
        synchronized (wSConsumerResultSet) {
            this.rowIndex = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        if (this.numOfRows == 0) {
            return false;
        }
        WSConsumerResultSet wSConsumerResultSet = this;
        synchronized (wSConsumerResultSet) {
            this.rowIndex = this.numOfRows - 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRow() throws SQLException {
        int row;
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        WSConsumerResultSet wSConsumerResultSet = this;
        synchronized (wSConsumerResultSet) {
            if (this.rowIndex < 0 || this.rowIndex >= this.numOfRows) {
                return 0;
            }
            row = this.rowIndex + 1;
        }
        return row;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw TSDBError.createSQLException(8965);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    public Object parseValue(int columnIndex) {
        Object source = this.result.get(columnIndex - 1).get(this.rowIndex);
        if (null == source) {
            return null;
        }
        int type = this.fields.get(columnIndex - 1).getTaosType();
        if (type == 9) {
            Long o = (Long)DataTypeConverUtil.parseValue(type, source);
            Instant instant = DateTimeUtils.parseTimestampColumnData(o, this.timestampPrecision);
            return DateTimeUtils.getTimestamp(instant, null);
        }
        return DataTypeConverUtil.parseValue(type, source);
    }
}

