/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.utils.SqlSyntaxValidator;
import com.taosdata.jdbc.ws.BlockResultSet;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.QueryResp;
import com.taosdata.jdbc.ws.entity.Response;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;

public class WSStatement
extends AbstractStatement {
    protected Transport transport;
    protected String database;
    private final AbstractConnection connection;
    private boolean closed;
    protected ResultSet resultSet;
    private int queryTimeout = 0;
    protected final ZoneId zoneId;
    protected final ZoneId stdZoneId = ZoneId.of("UTC");

    public WSStatement(Transport transport, String database, AbstractConnection connection, Long instanceId, ZoneId zoneId) {
        this.transport = transport;
        this.database = database;
        this.connection = connection;
        this.instanceId = instanceId;
        this.connection.registerStatement(this.instanceId, this);
        this.zoneId = zoneId;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Long reqId) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql, reqId);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, (Long)null);
    }

    @Override
    public int executeUpdate(String sql, Long reqId) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        this.execute(sql, reqId);
        return this.affectedRows;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.connection.unregisterStatement(this.instanceId);
            this.closed = true;
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, (Long)null);
    }

    @Override
    public boolean execute(String sql, Long reqId) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (null == reqId) {
            reqId = ReqId.getReqID();
        }
        byte[] sqlBytes = sql.getBytes();
        byte[] result = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN).putShort((short)1).putInt(sqlBytes.length).array();
        Response response = this.transport.send(Action.BINARY_QUERY.getAction(), reqId, 0L, 6L, result, sqlBytes);
        QueryResp queryResp = (QueryResp)response;
        if (Code.SUCCESS.getCode() != queryResp.getCode()) {
            throw TSDBError.createSQLException(queryResp.getCode(), queryResp.getMessage());
        }
        if (SqlSyntaxValidator.isUseSql(sql)) {
            this.database = SqlSyntaxValidator.getDatabaseName(sql);
            this.connection.setCatalog(this.database);
            this.connection.setClientInfo("dbname", this.database);
        }
        if (queryResp.isUpdate()) {
            this.resultSet = null;
            this.affectedRows = queryResp.getAffectedRows();
            return false;
        }
        this.resultSet = new BlockResultSet(this, this.transport, queryResp, this.database, this.zoneId);
        this.affectedRows = -1;
        return true;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (seconds < 0) {
            throw TSDBError.createSQLException(8963);
        }
        this.queryTimeout = seconds;
        this.transport.setTimeout((long)seconds * 1000L);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

