/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Utils {
    private static final Pattern ptn = Pattern.compile(".*?'");

    public static String escapeSingleQuota(String origin) {
        Matcher m = ptn.matcher(origin);
        StringBuilder sb = new StringBuilder();
        int end = 0;
        while (m.find()) {
            end = m.end();
            String seg = origin.substring(m.start(), end);
            int len = seg.length();
            if (len == 1) {
                if ('\'' == seg.charAt(0)) {
                    sb.append("\\'");
                    continue;
                }
                sb.append(seg);
                continue;
            }
            sb.append(seg, 0, seg.length() - 2);
            char lastcSec = seg.charAt(seg.length() - 2);
            if (lastcSec == '\\') {
                sb.append("\\'");
                continue;
            }
            sb.append(lastcSec);
            sb.append("\\'");
        }
        if (end < origin.length()) {
            sb.append(origin.substring(end));
        }
        return sb.toString();
    }

    public static String getNativeSql(String rawSql, Object[] parameters) {
        if (parameters == null || !rawSql.contains("?")) {
            return rawSql;
        }
        String preparedSql = rawSql.trim().toLowerCase();
        String[] clause = new String[]{"tags\\s*\\([\\s\\S]*?\\)", "where[\\s\\S]*"};
        HashMap<Integer, Integer> placeholderPositions = new HashMap<Integer, Integer>();
        TreeRangeSet clauseRangeSet = TreeRangeSet.create();
        Utils.findPlaceholderPosition(preparedSql, placeholderPositions);
        Utils.findClauseRangeSet(preparedSql, clause, (RangeSet<Integer>)clauseRangeSet);
        Utils.findValuesClauseRangeSet(preparedSql, (RangeSet<Integer>)clauseRangeSet);
        return Utils.transformSql(rawSql, parameters, placeholderPositions, (RangeSet<Integer>)clauseRangeSet);
    }

    private static void findValuesClauseRangeSet(String preparedSql, RangeSet<Integer> clauseRangeSet) {
        Matcher matcher = Pattern.compile("(values||,)\\s*(\\([^)]*\\))").matcher(preparedSql);
        while (matcher.find()) {
            int start = matcher.start(2);
            int end = matcher.end(2);
            clauseRangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
        }
    }

    private static void findClauseRangeSet(String preparedSql, String[] regexArr, RangeSet<Integer> clauseRangeSet) {
        clauseRangeSet.clear();
        for (String regex : regexArr) {
            Matcher matcher = Pattern.compile(regex).matcher(preparedSql);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                clauseRangeSet.add(Range.closedOpen((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)));
            }
        }
    }

    private static void findPlaceholderPosition(String preparedSql, Map<Integer, Integer> placeholderPosition) {
        placeholderPosition.clear();
        Matcher matcher = Pattern.compile("\\?").matcher(preparedSql);
        int index = 0;
        while (matcher.find()) {
            int pos = matcher.start();
            placeholderPosition.put(index, pos);
            ++index;
        }
    }

    private static String transformSql(String rawSql, Object[] paramArr, Map<Integer, Integer> placeholderPosition, RangeSet<Integer> clauseRangeSet) {
        String[] sqlArr = rawSql.split("\\?");
        return IntStream.range(0, sqlArr.length).mapToObj(index -> {
            String paraStr;
            if (index == paramArr.length) {
                return sqlArr[index];
            }
            Object para = paramArr[index];
            if (para != null) {
                paraStr = para instanceof byte[] ? new String((byte[])para, StandardCharsets.UTF_8) : para.toString();
                if (para instanceof Timestamp || para instanceof String || para instanceof byte[]) {
                    paraStr = Utils.escapeSingleQuota(paraStr);
                    Integer pos = (Integer)placeholderPosition.get(index);
                    boolean contains = clauseRangeSet.contains((Comparable)pos);
                    if (contains) {
                        paraStr = "'" + paraStr + "'";
                    }
                }
            } else {
                paraStr = "NULL";
            }
            return sqlArr[index] + paraStr;
        }).collect(Collectors.joining());
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            return Utils.class.getClassLoader();
        }
        return cl;
    }

    public static Class<?> parseClassType(String key) {
        ClassLoader contextClassLoader = Utils.getClassLoader();
        try {
            return Class.forName(key, true, contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> c) {
        if (c == null) {
            throw new RuntimeException("class cannot be null");
        }
        try {
            Constructor<T> declaredConstructor = c.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a public no-argument constructor for " + c.getName(), e);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            throw new RuntimeException("Could not instantiate class " + c.getName(), e);
        }
    }

    public static boolean isValidIP(String ip) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

