/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class JsonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static ObjectReader getObjectReader(Class<?> clazz) {
        return objectMapper.readerFor(clazz);
    }

    public static ObjectReader getObjectReader() {
        return objectMapper.reader();
    }

    public static ObjectWriter getObjectWriter(Class<?> clazz) {
        return objectMapper.writerFor(clazz);
    }

    public static ObjectWriter getObjectWriter() {
        return objectMapper.writer();
    }

    private static void configureObjectMapper(ObjectMapper objectMapper) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.registerModule((Module)new JavaTimeModule());
    }

    static {
        JsonUtil.configureObjectMapper(objectMapper);
    }
}

