/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.tmq;

import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.tmq.Deserializer;
import com.taosdata.jdbc.tmq.DeserializerException;
import com.taosdata.jdbc.utils.Utils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;

public class ReferenceDeserializer<V>
implements Deserializer<V> {
    private Param[] params;

    @Override
    public void configure(Map<?, ?> configs) {
        Object encodingValue = configs.get("value.deserializer.encoding");
        if (encodingValue instanceof String) {
            TaosGlobalConfig.setCharset(((String)encodingValue).trim());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V deserialize(ResultSet data, String topic, String dbName) throws DeserializerException, SQLException {
        Class<V> clazz = this.getGenericType();
        V t = null;
        try {
            t = Utils.newInstance(clazz);
            if (this.params == null) {
                void var10_15;
                ArrayList<Param> lists = new ArrayList<Param>();
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                int n = propertyDescriptorArray.length;
                boolean bl = false;
                while (var10_15 < n) {
                    Method method;
                    PropertyDescriptor property = propertyDescriptorArray[var10_15];
                    String name = property.getName();
                    if (!"class".equals(name) && null != (method = property.getWriteMethod())) {
                        method.setAccessible(true);
                        Param param = new Param();
                        param.name = name;
                        param.method = method;
                        param.clazz = method.getParameterTypes()[0];
                        lists.add(param);
                    }
                    ++var10_15;
                }
                this.params = lists.toArray(new Param[0]);
            }
        }
        catch (IntrospectionException e) {
            throw new SQLException(this.getClass().getSimpleName() + " get BeanInfo error!", e);
        }
        for (Param param : this.params) {
            try {
                if (param.clazz.isAssignableFrom(String.class)) {
                    String string = data.getString(param.name);
                    param.method.invoke(t, data.wasNull() ? null : string);
                    continue;
                }
                if (param.clazz.isAssignableFrom(Integer.class)) {
                    int n = data.getInt(param.name);
                    param.method.invoke(t, data.wasNull() ? null : Integer.valueOf(n));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Integer.TYPE)) {
                    param.method.invoke(t, data.getInt(param.name));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Short.class)) {
                    short s = data.getShort(param.name);
                    param.method.invoke(t, data.wasNull() ? null : Short.valueOf(s));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Short.TYPE)) {
                    param.method.invoke(t, data.getShort(param.name));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Byte.class)) {
                    byte by = data.getByte(param.name);
                    param.method.invoke(t, data.wasNull() ? null : Byte.valueOf(by));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Byte.TYPE)) {
                    param.method.invoke(t, data.getByte(param.name));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Character.class)) {
                    char c = (char)data.getByte(param.name);
                    param.method.invoke(t, data.wasNull() ? null : Character.valueOf(c));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Character.TYPE)) {
                    param.method.invoke(t, Character.valueOf((char)data.getByte(param.name)));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Float.class)) {
                    float f = data.getFloat(param.name);
                    param.method.invoke(t, data.wasNull() ? null : Float.valueOf(f));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Float.TYPE)) {
                    param.method.invoke(t, Float.valueOf(data.getFloat(param.name)));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Double.class)) {
                    double d = data.getDouble(param.name);
                    param.method.invoke(t, data.wasNull() ? null : Double.valueOf(d));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Double.TYPE)) {
                    param.method.invoke(t, data.getDouble(param.name));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Long.class)) {
                    long l = data.getLong(param.name);
                    param.method.invoke(t, data.wasNull() ? null : Long.valueOf(l));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Long.TYPE)) {
                    param.method.invoke(t, data.getLong(param.name));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Boolean.class)) {
                    boolean bl = data.getBoolean(param.name);
                    param.method.invoke(t, data.wasNull() ? null : Boolean.valueOf(bl));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Boolean.TYPE)) {
                    param.method.invoke(t, data.getBoolean(param.name));
                    continue;
                }
                if (param.clazz.isAssignableFrom(Timestamp.class)) {
                    Timestamp timestamp = data.getTimestamp(param.name);
                    param.method.invoke(t, data.wasNull() ? null : timestamp);
                    continue;
                }
                if (param.clazz.isAssignableFrom(Byte[].class) || param.clazz.isAssignableFrom(byte[].class)) {
                    byte[] byArray = data.getBytes(param.name);
                    param.method.invoke(t, new Object[]{data.wasNull() ? null : byArray});
                    continue;
                }
                if (param.clazz.isAssignableFrom(BigDecimal.class)) {
                    BigDecimal bigDecimal = data.getBigDecimal(param.name);
                    param.method.invoke(t, data.wasNull() ? null : bigDecimal);
                    continue;
                }
                if (!param.clazz.isAssignableFrom(BigInteger.class)) continue;
                BigInteger bigInteger = (BigInteger)data.getObject(param.name);
                param.method.invoke(t, data.wasNull() ? null : bigInteger);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                throw new SQLException(this.getClass().getSimpleName() + ": " + param.name + " through method:" + param.method.getName() + " get Data error: ", reflectiveOperationException);
            }
        }
        return t;
    }

    private Class<V> getGenericType() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        throw new RuntimeException("ReferenceDeserializer getGenericType error!, maybe not extends ReferenceDeserializer");
    }

    private static class Param {
        String name;
        Method method;
        Class<?> clazz;

        private Param() {
        }
    }
}

