/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.enums;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.utils.StringUtils;
import java.sql.SQLException;

public enum DataType {
    NULL("NULL", 0, 0, 0),
    BOOL("BOOL", 16, 1, 1),
    TINYINT("TINYINT", -6, 2, 3),
    UTINYINT("TINYINT UNSIGNED", 5, 11, 3),
    USMALLINT("SMALLINT UNSIGNED", 4, 12, 5),
    SMALLINT("SMALLINT", 5, 3, 5),
    UINT("INT UNSIGNED", -5, 13, 10),
    INT("INT", 4, 4, 10),
    UBIGINT("BIGINT UNSIGNED", 1111, 14, 20),
    BIGINT("BIGINT", -5, 5, 19),
    FLOAT("FLOAT", 6, 6, 12),
    DOUBLE("DOUBLE", 8, 7, 22),
    BINARY("BINARY", 12, 8, 0),
    VARCHAR("VARCHAR", 12, 8, 0),
    TIMESTAMP("TIMESTAMP", 93, 9, 0),
    NCHAR("NCHAR", -15, 10, 0),
    JSON("JSON", 1111, 15, 0),
    VARBINARY("VARBINARY", -3, 16, 0),
    GEOMETRY("GEOMETRY", -2, 20, 0);

    private final String typeName;
    private final int jdbcTypeValue;
    private final int taosTypeValue;
    private final int size;

    private DataType(String typeName, int jdbcTypeValue, int taosTypeValue, int size) {
        this.typeName = typeName;
        this.jdbcTypeValue = jdbcTypeValue;
        this.taosTypeValue = taosTypeValue;
        this.size = size;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getTaosTypeValue() {
        return this.taosTypeValue;
    }

    public int getJdbcTypeValue() {
        return this.jdbcTypeValue;
    }

    public int getSize() {
        return this.size;
    }

    public static DataType getDataType(String name) {
        if (StringUtils.isEmpty(name)) {
            return NULL;
        }
        name = name.trim().toUpperCase();
        for (DataType type : DataType.values()) {
            if (!name.equals(type.getTypeName())) continue;
            return type;
        }
        return NULL;
    }

    public static DataType convertJDBC2DataType(int jdbcType) throws SQLException {
        for (DataType type : DataType.values()) {
            if (jdbcType != type.getJdbcTypeValue()) continue;
            return type;
        }
        throw TSDBError.createSQLException(8975, "unknown sql type: " + jdbcType + " in tdengine");
    }

    public static DataType convertTaosType2DataType(int taosType) throws SQLException {
        for (DataType type : DataType.values()) {
            if (taosType != type.getTaosTypeValue()) continue;
            return type;
        }
        throw TSDBError.createSQLException(8981, "unknown taos type: " + taosType + " in tdengine");
    }

    public static int calculateColumnSize(String typeName, String precisionType, int length) {
        if (StringUtils.isEmpty(typeName)) {
            return -1;
        }
        DataType tmp = null;
        typeName = typeName.trim().toUpperCase();
        for (DataType type : DataType.values()) {
            if (!typeName.equals(type.getTypeName())) continue;
            tmp = type;
        }
        if (null == tmp) {
            return -1;
        }
        if (0 == tmp.getSize()) {
            if (tmp == TIMESTAMP) {
                return precisionType.equals("ms") ? 23 : 26;
            }
            if (tmp == NCHAR || tmp == BINARY || tmp == VARCHAR || tmp == VARBINARY || tmp == GEOMETRY) {
                return length;
            }
        }
        return tmp.getSize();
    }

    public static Integer calculateDecimalDigits(String typeName) {
        switch (typeName) {
            case "TINYINT": 
            case "TINYINT UNSIGNED": 
            case "SMALLINT": 
            case "SMALLINT UNSIGNED": 
            case "INT": 
            case "INT UNSIGNED": 
            case "BIGINT": 
            case "BIGINT UNSIGNED": {
                return 0;
            }
            case "FLOAT": {
                return 5;
            }
            case "DOUBLE": {
                return 16;
            }
        }
        return null;
    }
}

