/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.SchemalessResp;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBException;
import com.taosdata.jdbc.TSDBResultSetBlockData;
import com.taosdata.jdbc.TSDBResultSetRowData;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.VGroupIDResp;
import com.taosdata.jdbc.enums.SchemalessProtocolType;
import com.taosdata.jdbc.enums.SchemalessTimestampType;
import com.taosdata.jdbc.utils.TaosInfo;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.time.ZoneId;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TSDBJNIConnector {
    private static final Object LOCK = new Object();
    private static volatile boolean isInitialized;
    private final TaosInfo taosInfo = TaosInfo.getInstance();
    protected long taos = 0L;
    private boolean isResultsetClosed;
    private int affectedRows = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Properties props) throws SQLWarning {
        Object object = LOCK;
        synchronized (object) {
            if (!isInitialized) {
                String cfg;
                ObjectMapper objectMapper = new ObjectMapper();
                ObjectNode configJSON = objectMapper.createObjectNode();
                for (String key : props.stringPropertyNames()) {
                    configJSON.put(key, props.getProperty(key));
                }
                try {
                    cfg = objectMapper.writeValueAsString((Object)configJSON);
                }
                catch (JsonProcessingException e) {
                    throw TSDBError.createSQLWarning("Failed to parse properties to JSON string.");
                }
                TSDBJNIConnector.setConfigImp(cfg);
                TSDBJNIConnector.initImp(props.getProperty("cfgdir", null));
                String locale = props.getProperty("locale");
                if (TSDBJNIConnector.setOptions(0, locale) < 0) {
                    throw TSDBError.createSQLWarning("Failed to set locale: " + locale + ". System default will be used.");
                }
                String charset = props.getProperty("charset");
                if (TSDBJNIConnector.setOptions(1, charset) < 0) {
                    throw TSDBError.createSQLWarning("Failed to set charset: " + charset + ". System default will be used.");
                }
                String timezone = props.getProperty("timezone");
                if (TSDBJNIConnector.setOptions(2, timezone) < 0) {
                    throw TSDBError.createSQLWarning("Failed to set timezone: " + timezone + ". System default will be used.");
                }
                try {
                    TSDBJNIConnector.handleTimeZone(timezone.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                isInitialized = true;
                TaosGlobalConfig.setCharset(TSDBJNIConnector.getTsCharset());
            }
        }
    }

    private static void handleTimeZone(String posixTimeZoneStr) {
        if (posixTimeZoneStr.startsWith("UTC") || posixTimeZoneStr.startsWith("GMT")) {
            if (posixTimeZoneStr.length() == 3) {
                TimeZone.setDefault(TimeZone.getTimeZone(ZoneId.of("GMT")));
                return;
            }
            String regex = "^(UTC|GMT)([+-])(\\d+)$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(posixTimeZoneStr);
            if (matcher.matches()) {
                String op = matcher.group(2);
                String hourStr = matcher.group(3);
                op = op.equals("+") ? "-" : "+";
                int hour = Integer.parseInt(hourStr);
                if (hour > 18) {
                    return;
                }
                String timezone = String.format("GMT%s%02d:00", op, hour);
                TimeZone.setDefault(TimeZone.getTimeZone(ZoneId.of(timezone)));
                return;
            }
        }
        if (posixTimeZoneStr.contains("/")) {
            TimeZone.setDefault(TimeZone.getTimeZone(ZoneId.of(posixTimeZoneStr)));
        }
    }

    private static native void initImp(String var0);

    private static native int setOptions(int var0, String var1);

    private static native String getTsCharset();

    private static native TSDBException setConfigImp(String var0);

    public boolean connect(String host, int port, String dbName, String user, String password) throws SQLException {
        if (this.taos != 0L) {
            this.closeConnection();
            this.taos = 0L;
        }
        this.taos = this.connectImp(host, port, dbName, user, password);
        if (this.taos == 0L) {
            String errMsg = this.getErrMsg(0L);
            throw TSDBError.createSQLException(9044, errMsg);
        }
        this.taosInfo.conn_open_increment();
        return true;
    }

    private native long connectImp(String var1, int var2, String var3, String var4, String var5);

    public long executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null);
    }

    private native long executeQueryImp(byte[] var1, long var2);

    public long executeQuery(String sql, Long reqId) throws SQLException {
        long pSql = 0L;
        try {
            pSql = null == reqId ? this.executeQueryImp(sql.getBytes(TaosGlobalConfig.getCharset()), this.taos) : this.executeQueryWithReqId(sql.getBytes(TaosGlobalConfig.getCharset()), this.taos, reqId);
            this.taosInfo.stmt_count_increment();
        }
        catch (UnsupportedEncodingException e) {
            this.freeResultSetImp(this.taos, pSql);
            throw TSDBError.createSQLException(9042);
        }
        if (pSql == -2L) {
            this.freeResultSetImp(this.taos, pSql);
            throw TSDBError.createSQLException(9044);
        }
        if (pSql == -5L) {
            this.freeResultSetImp(this.taos, pSql);
            throw TSDBError.createSQLException(9047);
        }
        if (pSql == -7L) {
            this.freeResultSetImp(this.taos, pSql);
            throw TSDBError.createSQLException(9049);
        }
        int code = this.getErrCode(pSql);
        if (code != 0) {
            this.affectedRows = -1;
            String msg = this.getErrMsg(pSql);
            this.freeResultSetImp(this.taos, pSql);
            throw TSDBError.createSQLException(code, msg);
        }
        this.isResultsetClosed = (pSql = this.getResultSetImp(this.taos, pSql)) == 0L;
        return pSql;
    }

    private native long executeQueryWithReqId(byte[] var1, long var2, long var4);

    public int getErrCode(long pSql) {
        return this.getErrCodeImp(this.taos, pSql);
    }

    private native int getErrCodeImp(long var1, long var3);

    public String getErrMsg(long pSql) {
        return this.getErrMsgImp(pSql);
    }

    private native String getErrMsgImp(long var1);

    private native long getResultSetImp(long var1, long var3);

    public boolean isUpdateQuery(long pSql) {
        return this.isUpdateQueryImp(this.taos, pSql) == 1L;
    }

    private native long isUpdateQueryImp(long var1, long var3);

    public boolean isClosed() {
        return this.taos == 0L;
    }

    public boolean isResultsetClosed() {
        return this.isResultsetClosed;
    }

    public int freeResultSet(long pSql) {
        int res = this.freeResultSetImp(this.taos, pSql);
        this.isResultsetClosed = true;
        return res;
    }

    private native int freeResultSetImp(long var1, long var3);

    public int getAffectedRows(long pSql) {
        int affectedRows = this.affectedRows;
        if (affectedRows < 0) {
            affectedRows = this.getAffectedRowsImp(this.taos, pSql);
        }
        return affectedRows;
    }

    private native int getAffectedRowsImp(long var1, long var3);

    public int getSchemaMetaData(long resultSet, List<ColumnMetaData> columnMetaData) {
        int ret = this.getSchemaMetaDataImp(this.taos, resultSet, columnMetaData);
        columnMetaData.forEach(column -> column.setColIndex(column.getColIndex() + 1));
        return ret;
    }

    private native int getSchemaMetaDataImp(long var1, long var3, List<ColumnMetaData> var5);

    public int fetchRow(long resultSet, TSDBResultSetRowData rowData) {
        return this.fetchRowImp(this.taos, resultSet, rowData);
    }

    private native int fetchRowImp(long var1, long var3, TSDBResultSetRowData var5);

    public int fetchBlock(long resultSet, TSDBResultSetBlockData blockData) {
        return this.fetchBlockImp(this.taos, resultSet, blockData);
    }

    private native int fetchBlockImp(long var1, long var3, TSDBResultSetBlockData var5);

    public int getResultTimePrecision(long sqlObj) {
        return this.getResultTimePrecisionImp(this.taos, sqlObj);
    }

    private native int getResultTimePrecisionImp(long var1, long var3);

    public void closeConnection() throws SQLException {
        int code = this.closeConnectionImp(this.taos);
        if (code < 0) {
            throw TSDBError.createSQLException(9044);
        }
        if (code != 0) {
            throw new SQLException("Undefined error code returned by TDengine when closing a connection");
        }
        this.taos = 0L;
        this.taosInfo.connect_close_increment();
    }

    private native int closeConnectionImp(long var1);

    public long prepareStmt(String sql) throws SQLException {
        return this.prepareStmt(sql, null);
    }

    private native long prepareStmtImp(byte[] var1, long var2);

    public long prepareStmt(String sql, Long reqId) throws SQLException {
        long stmt = null == reqId ? this.prepareStmtImp(sql.getBytes(), this.taos) : this.prepareStmtWithReqId(sql.getBytes(), this.taos, reqId);
        if (stmt == -2L) {
            throw TSDBError.createSQLException(9044, "connection already closed");
        }
        if (stmt == -5L) {
            throw TSDBError.createSQLException(9047);
        }
        if (stmt == -7L) {
            throw TSDBError.createSQLException(9049);
        }
        if (stmt == -1L) {
            throw TSDBError.createSQLException(9043);
        }
        return stmt;
    }

    private native long prepareStmtWithReqId(byte[] var1, long var2, long var4);

    public void setBindTableName(long stmt, String tableName) throws SQLException {
        int code = this.setBindTableNameImp(stmt, tableName, this.taos);
        if (code != 0) {
            throw TSDBError.createSQLException(code, "failed to set table name, reason: " + this.stmtErrorMsgImp(stmt, this.taos));
        }
    }

    private native int setBindTableNameImp(long var1, String var3, long var4);

    public void setBindTableNameAndTags(long stmt, String tableName, int numOfTags, ByteBuffer tags, ByteBuffer typeList, ByteBuffer lengthList, ByteBuffer nullList) throws SQLException {
        int code = this.setTableNameTagsImp(stmt, tableName, numOfTags, tags.array(), typeList.array(), lengthList.array(), nullList.array(), this.taos);
        if (code != 0) {
            throw TSDBError.createSQLException(code, "failed to bind table name and corresponding tags, reason: " + this.stmtErrorMsgImp(stmt, this.taos));
        }
    }

    private native int setTableNameTagsImp(long var1, String var3, int var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, long var9);

    public void bindColumnDataArray(long stmt, ByteBuffer colDataList, ByteBuffer lengthList, ByteBuffer isNullList, int type, int bytes, int numOfRows, int columnIndex) throws SQLException {
        int code = this.bindColDataImp(stmt, colDataList.array(), lengthList.array(), isNullList.array(), type, bytes, numOfRows, columnIndex, this.taos);
        if (code != 0) {
            throw TSDBError.createSQLException(code, "failed to bind column data, reason: " + this.stmtErrorMsgImp(stmt, this.taos));
        }
    }

    private native int bindColDataImp(long var1, byte[] var3, byte[] var4, byte[] var5, int var6, int var7, int var8, int var9, long var10);

    public void executeBatch(long stmt) throws SQLException {
        int code = this.executeBatchImp(stmt, this.taos);
        if (code != 0) {
            throw TSDBError.createSQLException(code, "failed to execute batch bind, reason: " + this.stmtErrorMsgImp(stmt, this.taos));
        }
    }

    public void addBatch(long stmt) throws SQLException {
        int code = this.addBatchImp(stmt, this.taos);
        if (code != 0) {
            throw TSDBError.createSQLException(code, this.stmtErrorMsgImp(stmt, this.taos));
        }
    }

    private native int addBatchImp(long var1, long var3);

    private native int executeBatchImp(long var1, long var3);

    public void closeBatch(long stmt) throws SQLException {
        int code = this.closeStmt(stmt, this.taos);
        if (code != 0) {
            throw TSDBError.createSQLException(code, "failed to close batch bind: " + this.stmtErrorMsgImp(stmt, this.taos));
        }
    }

    private native int closeStmt(long var1, long var3);

    private native String stmtErrorMsgImp(long var1, long var3);

    public void insertLines(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        long pSql = this.schemalessInsertImp(lines, this.taos, protocolType.ordinal(), timestampType.ordinal());
        this.releaseSchemalessInsert(pSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSchemalessInsert(long pSql) throws SQLException {
        try {
            if (pSql == -2L) {
                throw TSDBError.createSQLException(9044);
            }
            if (pSql == -7L) {
                throw TSDBError.createSQLException(9049);
            }
            int code = this.getErrCode(pSql);
            if (code != 0) {
                String msg = this.getErrMsg(pSql);
                throw TSDBError.createSQLException(code, msg);
            }
        }
        finally {
            this.freeResultSetImp(this.taos, pSql);
        }
    }

    private native long schemalessInsertImp(String[] var1, long var2, int var4, int var5);

    public void insertLinesWithReqId(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, long reqId) throws SQLException {
        long pSql = this.schemalessInsertWithReqId(this.taos, lines, protocolType.ordinal(), timestampType.ordinal(), reqId);
        this.releaseSchemalessInsert(pSql);
    }

    private native long schemalessInsertWithReqId(long var1, String[] var3, int var4, int var5, long var6);

    public void insertLinesWithTtl(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, int ttl) throws SQLException {
        long pSql = this.schemalessInsertWithTtl(this.taos, lines, protocolType.ordinal(), timestampType.ordinal(), ttl);
        this.releaseSchemalessInsert(pSql);
    }

    private native long schemalessInsertWithTtl(long var1, String[] var3, int var4, int var5, int var6);

    public void insertLinesWithTtlAndReqId(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, int ttl, long reqId) throws SQLException {
        long pSql = this.schemalessInsertWithTtlAndReqId(this.taos, lines, protocolType.ordinal(), timestampType.ordinal(), ttl, reqId);
        this.releaseSchemalessInsert(pSql);
    }

    private native long schemalessInsertWithTtlAndReqId(long var1, String[] var3, int var4, int var5, int var6, long var7);

    public int insertRaw(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType) throws SQLException {
        if (null == line) {
            throw TSDBError.createSQLException(8963);
        }
        SchemalessResp resp = this.schemalessInsertRaw(this.taos, line, protocolType.ordinal(), timestampType.ordinal());
        if (0 != resp.getCode()) {
            throw TSDBError.createSQLException(resp.getCode(), resp.getMsg());
        }
        return resp.getTotalRows();
    }

    private native SchemalessResp schemalessInsertRaw(long var1, String var3, int var4, int var5);

    public int insertRawWithReqId(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, long reqId) throws SQLException {
        if (null == line) {
            throw TSDBError.createSQLException(8963);
        }
        SchemalessResp resp = this.schemalessInsertRawWithReqId(this.taos, line, protocolType.ordinal(), timestampType.ordinal(), reqId);
        if (0 != resp.getCode()) {
            throw TSDBError.createSQLException(resp.getCode(), resp.getMsg());
        }
        return resp.getTotalRows();
    }

    private native SchemalessResp schemalessInsertRawWithReqId(long var1, String var3, int var4, int var5, long var6);

    public int insertRawWithTtl(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, int ttl) throws SQLException {
        if (null == line) {
            throw TSDBError.createSQLException(8963);
        }
        SchemalessResp resp = this.schemalessInsertRawWithTtl(this.taos, line, protocolType.ordinal(), timestampType.ordinal(), ttl);
        if (0 != resp.getCode()) {
            throw TSDBError.createSQLException(resp.getCode(), resp.getMsg());
        }
        return resp.getTotalRows();
    }

    private native SchemalessResp schemalessInsertRawWithTtl(long var1, String var3, int var4, int var5, int var6);

    public int insertRawWithTtlAndReqId(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, int ttl, long reqId) throws SQLException {
        if (null == line) {
            throw TSDBError.createSQLException(8963);
        }
        SchemalessResp resp = this.schemalessInsertRawWithTtlAndReqId(this.taos, line, protocolType.ordinal(), timestampType.ordinal(), ttl, reqId);
        if (0 != resp.getCode()) {
            throw TSDBError.createSQLException(resp.getCode(), resp.getMsg());
        }
        return resp.getTotalRows();
    }

    private native SchemalessResp schemalessInsertRawWithTtlAndReqId(long var1, String var3, int var4, int var5, int var6, long var7);

    public int getTableVGroupID(String db, String table) throws SQLException {
        VGroupIDResp resp = this.getTableVgID(this.taos, db, table, new VGroupIDResp());
        if (resp.getCode() != 0) {
            throw TSDBError.createSQLException(resp.getCode(), "get table vGroup id fail");
        }
        return resp.getVgID();
    }

    private native VGroupIDResp getTableVgID(long var1, String var3, String var4, VGroupIDResp var5);

    static {
        System.loadLibrary("taos");
    }
}

