/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBErrorNumbers;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class TSDBError {
    private static final Map<Integer, String> TSDBErrorMap = new HashMap<Integer, String>();

    public static SQLException createSQLException(int errorCode) {
        String message = TSDBErrorNumbers.contains(errorCode) ? TSDBErrorMap.get(errorCode) : TSDBErrorMap.get(9040);
        return TSDBError.createSQLException(errorCode, message);
    }

    public static SQLException createSQLException(int errorCode, String message) {
        if (errorCode == 8962) {
            return new SQLFeatureNotSupportedException(message, "", errorCode);
        }
        if (errorCode == 8974) {
            return new SQLClientInfoException(message, null);
        }
        if (errorCode > 8960 && errorCode < 9040) {
            return new SQLException("ERROR (0x" + Integer.toHexString(errorCode) + "): " + message, "", errorCode);
        }
        if (errorCode > 9040 && errorCode < 9072) {
            return new SQLException("JNI ERROR (0x" + Integer.toHexString(errorCode) + "): " + message, "", errorCode);
        }
        if (errorCode > 9072 && errorCode < 9216) {
            return new SQLException("Consumer ERROR (0x" + Integer.toHexString(errorCode) + "): " + message, "", errorCode);
        }
        return new SQLException("TDengine ERROR (0x" + Integer.toHexString(errorCode) + "): " + message, "", errorCode);
    }

    public static RuntimeException createRuntimeException(int errorCode, Throwable t) {
        String message = TSDBErrorMap.get(errorCode);
        return new RuntimeException("ERROR (0x" + Integer.toHexString(errorCode) + "): " + message, t);
    }

    public static SQLWarning createSQLWarning(String message) {
        return new SQLWarning(message);
    }

    public static SQLException undeterminedExecutionError() {
        return new SQLException("Please either call clearBatch() to clean up context first, or use executeBatch() instead", (String)null);
    }

    public static IllegalArgumentException createIllegalArgumentException(int errorCode) {
        String message = TSDBErrorNumbers.contains(errorCode) ? TSDBErrorMap.get(errorCode) : TSDBErrorMap.get(9040);
        return new IllegalArgumentException("ERROR (0x" + Integer.toHexString(errorCode) + "): " + message);
    }

    public static RuntimeException createRuntimeException(int errorCode) {
        String message = TSDBErrorNumbers.contains(errorCode) ? TSDBErrorMap.get(errorCode) : TSDBErrorMap.get(9040);
        return new RuntimeException("ERROR (0x" + Integer.toHexString(errorCode) + "): " + message);
    }

    public static RuntimeException createRuntimeException(int errorCode, String message) {
        return new RuntimeException("ERROR (0x" + Integer.toHexString(errorCode) + "): " + message);
    }

    public static IllegalStateException createIllegalStateException(int errorCode) {
        String message = TSDBErrorNumbers.contains(errorCode) ? TSDBErrorMap.get(errorCode) : TSDBErrorMap.get(9040);
        return new IllegalStateException("ERROR (0x" + Integer.toHexString(errorCode) + "): " + message);
    }

    public static TimeoutException createTimeoutException(int errorCode, String message) {
        return new TimeoutException("ERROR (0x" + Integer.toHexString(errorCode) + "): " + message);
    }

    static {
        TSDBErrorMap.put(8961, "connection already closed");
        TSDBErrorMap.put(8962, "this operation is NOT supported currently!");
        TSDBErrorMap.put(8963, "invalid variables");
        TSDBErrorMap.put(8964, "statement is closed");
        TSDBErrorMap.put(8965, "resultSet is closed");
        TSDBErrorMap.put(8966, "Batch is empty!");
        TSDBErrorMap.put(8967, "Can not issue data manipulation statements with executeQuery()");
        TSDBErrorMap.put(8968, "Can not issue SELECT via executeUpdate()");
        TSDBErrorMap.put(8969, "invalid sql for executeQuery: (?)");
        TSDBErrorMap.put(8970, "Database not specified or available");
        TSDBErrorMap.put(8971, "invalid sql for executeUpdate: (?)");
        TSDBErrorMap.put(8972, "invalid sql for execute: (?)");
        TSDBErrorMap.put(8973, "parameter index out of range");
        TSDBErrorMap.put(8974, "connection already closed");
        TSDBErrorMap.put(8975, "unknown sql type in tdengine");
        TSDBErrorMap.put(8976, "can't register JDBC-JNI driver");
        TSDBErrorMap.put(8977, "can't register JDBC-RESTful driver");
        TSDBErrorMap.put(8978, "url is not set");
        TSDBErrorMap.put(8979, "invalid sql");
        TSDBErrorMap.put(8980, "numeric value out of range");
        TSDBErrorMap.put(8981, "unknown taos type in tdengine");
        TSDBErrorMap.put(8982, "unknown timestamp precision");
        TSDBErrorMap.put(8985, "user is required");
        TSDBErrorMap.put(8986, "password is required");
        TSDBErrorMap.put(8987, "invalid json format");
        TSDBErrorMap.put(8989, "create connection with server timeout");
        TSDBErrorMap.put(8990, "query timeout");
        TSDBErrorMap.put(9040, "unknown error");
        TSDBErrorMap.put(9041, "failed to create subscription");
        TSDBErrorMap.put(9042, "Unsupported encoding");
        TSDBErrorMap.put(9043, "internal error of database, please see taoslog for more details");
        TSDBErrorMap.put(9044, "JNI connection is NULL");
        TSDBErrorMap.put(9045, "JNI result set is NULL");
        TSDBErrorMap.put(9046, "invalid num of fields");
        TSDBErrorMap.put(9047, "empty sql string");
        TSDBErrorMap.put(9048, "fetch to the end of resultSet");
        TSDBErrorMap.put(9049, "JNI alloc memory failed, please see taoslog for more details");
        TSDBErrorMap.put(9073, "consumer config reference has been destroyed");
        TSDBErrorMap.put(9074, "configs contain empty key, failed to set consumer property");
        TSDBErrorMap.put(9075, "consumer configs contain empty value, failed to set consumer property");
        TSDBErrorMap.put(9076, "consumer config error");
        TSDBErrorMap.put(9077, "topic reference has been destroyed");
        TSDBErrorMap.put(9078, "failed to set consumer topic, topic name is empty");
        TSDBErrorMap.put(9079, "consumer reference is null or has been destroyed");
        TSDBErrorMap.put(9080, "consumer create error");
        TSDBErrorMap.put(9081, "seek offset must not be a negative number");
        TSDBErrorMap.put(9082, "vGroup not found in result set");
    }
}

