/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.JsonUtil;
import com.taosdata.jdbc.utils.StringUtils;
import com.taosdata.jdbc.ws.FutureResponse;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSConnection;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.ConnectReq;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.FetchBlockNewResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDriver
implements Driver {
    private final Logger log = LoggerFactory.getLogger(AbstractDriver.class);

    protected DriverPropertyInfo[] getPropertyInfo(Properties info) {
        DriverPropertyInfo hostProp = new DriverPropertyInfo("host", info.getProperty("host"));
        hostProp.required = false;
        hostProp.description = "Hostname";
        DriverPropertyInfo portProp = new DriverPropertyInfo("port", info.getProperty("port"));
        portProp.required = false;
        portProp.description = "Port";
        DriverPropertyInfo dbProp = new DriverPropertyInfo("dbname", info.getProperty("dbname"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
        userProp.required = true;
        userProp.description = "User";
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        passwordProp.required = true;
        passwordProp.description = "Password";
        DriverPropertyInfo[] propertyInfo = new DriverPropertyInfo[]{hostProp, portProp, dbProp, userProp, passwordProp};
        return propertyInfo;
    }

    protected Properties parseURL(String url, Properties defaults) {
        return StringUtils.parseUrl(url, defaults);
    }

    protected Connection getWSConnection(String url, ConnectionParam param, Properties props) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("getWSConnection, url = {}", (Object)StringUtils.getBasicUrl(url));
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                this.log.debug("getWSConnection, ConnectionParam = {}", (Object)objectMapper.writeValueAsString((Object)param));
            }
            catch (JsonProcessingException e) {
                this.log.error("Error serializing ConnectionParam", (Throwable)e);
            }
        }
        InFlightRequest inFlightRequest = new InFlightRequest(param.getRequestTimeout(), param.getMaxRequest());
        Transport transport = new Transport(WSFunction.WS, param, inFlightRequest);
        transport.setTextMessageHandler(message -> {
            try {
                this.log.trace("received message: {}", message);
                JsonNode jsonObject = JsonUtil.getObjectReader().readTree(message);
                Action action = Action.of(jsonObject.get("action").asText());
                ObjectReader actionReader = JsonUtil.getObjectReader(action.getResponseClazz());
                Response response = (Response)actionReader.treeToValue((TreeNode)jsonObject, action.getResponseClazz());
                FutureResponse remove = inFlightRequest.remove(response.getAction(), response.getReqId());
                if (null != remove) {
                    remove.getFuture().complete(response);
                }
            }
            catch (JsonProcessingException e) {
                this.log.error("Error processing message", (Throwable)e);
            }
        });
        transport.setBinaryMessageHandler(byteBuffer -> {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.position(26);
            long id = byteBuffer.getLong();
            byteBuffer.position(8);
            FutureResponse remove = inFlightRequest.remove(Action.FETCH_BLOCK_NEW.getAction(), id);
            if (null != remove) {
                FetchBlockNewResp fetchBlockResp = new FetchBlockNewResp((ByteBuffer)byteBuffer);
                remove.getFuture().complete(fetchBlockResp);
            }
        });
        transport.checkConnection(param.getConnectTimeout());
        ConnectReq connectReq = new ConnectReq(param);
        ConnectResp auth = (ConnectResp)transport.send(new Request(Action.CONN.getAction(), connectReq));
        if (Code.SUCCESS.getCode() != auth.getCode()) {
            transport.close();
            throw new SQLException("(0x" + Integer.toHexString(auth.getCode()) + "):auth failure:" + auth.getMessage());
        }
        TaosGlobalConfig.setCharset(props.getProperty("charset"));
        return new WSConnection(url, props, transport, param);
    }
}

