/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class CompletableFutureTimeout {
    private CompletableFutureTimeout() {
    }

    public static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> future, long timeout, TimeUnit unit) {
        CompletableFuture<T> timeoutFuture = CompletableFutureTimeout.timeoutAfter(timeout, unit);
        return future.applyToEither((CompletionStage)timeoutFuture, Function.identity());
    }

    public static <T> CompletableFuture<T> orTimeout(T t, CompletableFuture<T> future, long timeout, TimeUnit unit) {
        CompletableFuture<T> timeoutFuture = CompletableFutureTimeout.timeoutAfter(timeout, unit);
        return ((CompletableFuture)future.applyToEither((CompletionStage)timeoutFuture, Function.identity())).exceptionally(throwable -> t);
    }

    private static <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        Delayer.delayer.schedule(() -> result.completeExceptionally(new TimeoutException(String.format("failed to complete the task within the specified time : %d,%s", new Object[]{timeout, unit}))), timeout, unit);
        return result;
    }

    static final class Delayer {
        static final ScheduledThreadPoolExecutor delayer = new ScheduledThreadPoolExecutor(1, new DaemonThreadFactory());

        private Delayer() {
        }

        static ScheduledFuture<?> delay(Runnable command, long delay, TimeUnit unit) {
            return delayer.schedule(command, delay, unit);
        }

        static {
            delayer.setRemoveOnCancelPolicy(true);
        }

        static final class DaemonThreadFactory
        implements ThreadFactory {
            DaemonThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("DelayScheduler-");
                return t;
            }
        }
    }
}

