/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.tmq;

import com.taosdata.jdbc.tmq.TopicPartition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ConsumerRecords<V>
implements Iterable<V> {
    public static final ConsumerRecords<?> EMPTY = new ConsumerRecords(Collections.emptyMap());
    private long offset;
    private final Map<TopicPartition, List<V>> records;

    public ConsumerRecords(Map<TopicPartition, List<V>> records) {
        this.records = records;
    }

    public ConsumerRecords(long offset) {
        this.records = new HashMap<TopicPartition, List<V>>();
        this.offset = offset;
    }

    protected long getOffset() {
        return this.offset;
    }

    public void put(TopicPartition tp, V v) {
        if (this.records.containsKey(tp)) {
            this.records.get(tp).add(v);
        } else {
            ArrayList<V> list = new ArrayList<V>();
            list.add(v);
            this.records.put(tp, list);
        }
    }

    public List<V> get(TopicPartition partition) {
        List<V> recs = this.records.get(partition);
        if (recs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(recs);
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            final Iterator<? extends Iterable<V>> iters;
            Iterator<V> current;
            {
                this.iters = ConsumerRecords.this.records.values().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.current == null || !this.current.hasNext()) {
                    if (this.iters.hasNext()) {
                        this.current = this.iters.next().iterator();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public V next() {
                return this.current.next();
            }
        };
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public static <T> ConsumerRecords<T> emptyRecord() {
        return EMPTY;
    }
}

