/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jobrestrictions.restrictions.job;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.Messages;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestrictionDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.Run;
import io.jenkins.plugins.jobrestrictions.util.ClassSelector;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="XStream does actually need serialization, the code needs refactoring in 1.0")
public class JobClassNameRestriction
extends JobRestriction {
    private final List<ClassSelector> jobClasses;
    private transient Set<String> acceptedClassesHash = null;

    @DataBoundConstructor
    public JobClassNameRestriction(List<ClassSelector> jobClasses) {
        this.jobClasses = jobClasses;
    }

    @Nonnull
    public List<ClassSelector> getJobClasses() {
        return this.jobClasses;
    }

    @Nonnull
    private synchronized Set<String> getAcceptedJobClasses() {
        if (this.acceptedClassesHash == null) {
            List<ClassSelector> selectors = this.getJobClasses();
            this.acceptedClassesHash = new HashSet<String>(selectors.size());
            for (ClassSelector selector : selectors) {
                this.acceptedClassesHash.add(selector.getSelectedClass());
            }
        }
        return this.acceptedClassesHash;
    }

    @Override
    public boolean canTake(Queue.BuildableItem item) {
        return this.getAcceptedJobClasses().contains(item.task.getClass().getName());
    }

    @Override
    public boolean canTake(Run run) {
        return this.getAcceptedJobClasses().contains(run.getParent().getClass().getName());
    }

    @Extension
    public static class DescriptorImpl
    extends JobRestrictionDescriptor {
        public String getDisplayName() {
            return Messages.restrictions_Job_JobClassNameRestriction_displayName();
        }
    }
}

