/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.util;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.util.JenkinsHelper;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.FormValidation;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.dao.DataAccessException;

public class GroupSelector
implements Describable<GroupSelector>,
Serializable {
    @CheckForNull
    String selectedGroupId;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public GroupSelector(@CheckForNull String selectedGroupId) {
        this.selectedGroupId = Util.fixEmptyAndTrim((String)selectedGroupId);
    }

    @CheckForNull
    public String getSelectedGroupId() {
        return this.selectedGroupId;
    }

    public Descriptor<GroupSelector> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GroupSelector) {
            GroupSelector cmp = (GroupSelector)obj;
            return this.selectedGroupId != null ? this.selectedGroupId.equals(cmp.selectedGroupId) : cmp.selectedGroupId == null;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.selectedGroupId != null ? this.selectedGroupId.hashCode() : 0);
        return hash;
    }

    public static class DescriptorImpl
    extends Descriptor<GroupSelector> {
        public String getDisplayName() {
            return "N/A";
        }

        public FormValidation doCheckSelectedGroupId(@QueryParameter String selectedGroupId) {
            selectedGroupId = Util.fixEmptyAndTrim((String)selectedGroupId);
            SecurityRealm sr = JenkinsHelper.getInstanceOrDie().getSecurityRealm();
            String eSelectedGroupId = Functions.escape((String)selectedGroupId);
            if (selectedGroupId == null) {
                return FormValidation.error((String)"Field is empty");
            }
            if (selectedGroupId.equals("authenticated")) {
                return FormValidation.ok();
            }
            try {
                GroupDetails details = sr.loadGroupByGroupname(selectedGroupId);
                if (details == null) {
                    return FormValidation.warning((String)("Group " + selectedGroupId + " is not registered in Jenkins"));
                }
                return FormValidation.ok();
            }
            catch (UserMayOrMayNotExistException e) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)eSelectedGroupId);
            }
            catch (UsernameNotFoundException usernameNotFoundException) {
            }
            catch (DataAccessException dataAccessException) {
            }
            catch (AuthenticationException authenticationException) {
                // empty catch block
            }
            return FormValidation.warning((String)("Group " + selectedGroupId + " is not registered in Jenkins"));
        }
    }
}

