/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.job;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.Messages;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestrictionDescriptor;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.util.QueueHelper;
import hudson.Extension;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RegexNameRestriction
extends JobRestriction {
    String regexExpression;
    boolean checkShortName;

    @DataBoundConstructor
    public RegexNameRestriction(String regexExpression, boolean checkShortName) {
        this.regexExpression = regexExpression;
        this.checkShortName = checkShortName;
    }

    public String getRegexExpression() {
        return this.regexExpression;
    }

    public boolean isCheckShortName() {
        return this.checkShortName;
    }

    @Override
    public boolean canTake(Queue.BuildableItem item) {
        return this.canTake(QueueHelper.getFullName(item));
    }

    @Override
    public boolean canTake(Run run) {
        return this.canTake(run.getParent().getFullName());
    }

    public boolean canTake(String projectName) {
        try {
            return projectName.matches(this.regexExpression);
        }
        catch (PatternSyntaxException ex) {
            return true;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JobRestrictionDescriptor {
        public String getDisplayName() {
            return Messages.restrictions_Job_RegexName();
        }

        public FormValidation doCheckRegexExpression(@QueryParameter String regexExpression) {
            try {
                Pattern.compile(regexExpression);
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)exception.getDescription());
            }
            return FormValidation.ok((String)Messages.restrictions_Job_RegexName_OkMessage());
        }
    }
}

