/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.job;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestriction;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Queue;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class AbstractUserCauseRestriction
extends JobRestriction {
    private final boolean checkUpstreamProjects;

    public AbstractUserCauseRestriction(boolean checkUpstreamProjects) {
        this.checkUpstreamProjects = checkUpstreamProjects;
    }

    public final boolean isCheckUpstreamProjects() {
        return this.checkUpstreamProjects;
    }

    protected abstract boolean acceptsUser(@CheckForNull String var1);

    boolean canTake(@Nonnull List<Cause> causes) {
        boolean userIdCause = false;
        boolean rebuildCause = false;
        boolean upstreamCause = false;
        boolean aUserIdWasNotAccepted = false;
        boolean userIdCauseExists = false;
        for (Cause cause : causes) {
            List upstreamCauses;
            if (cause == null) continue;
            if (cause.getClass().equals(Cause.UserIdCause.class) && !aUserIdWasNotAccepted) {
                userIdCauseExists = true;
                String startedBy = ((Cause.UserIdCause)cause).getUserId();
                if (this.acceptsUser(startedBy)) {
                    userIdCause = true;
                } else {
                    aUserIdWasNotAccepted = true;
                    userIdCause = false;
                }
            }
            if (!this.checkUpstreamProjects || !cause.getClass().equals(Cause.UpstreamCause.class) || !this.canTake(upstreamCauses = ((Cause.UpstreamCause)cause).getUpstreamCauses())) continue;
            upstreamCause = true;
        }
        if (userIdCauseExists) {
            return userIdCause;
        }
        return upstreamCause;
    }

    @Override
    public boolean canTake(Queue.BuildableItem item) {
        ArrayList<Cause> causes = new ArrayList<Cause>();
        for (Action action : item.getActions()) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            causes.addAll(causeAction.getCauses());
        }
        return this.canTake(causes);
    }

    @Override
    public boolean canTake(Run run) {
        return this.canTake(run.getCauses());
    }
}

