/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.jobrestrictions.jobs;

import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.Messages;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.jobs.JobCauseRestriction;
import com.synopsys.arc.jenkinsci.plugins.jobrestrictions.restrictions.JobRestriction;
import hudson.AbortException;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Run;
import org.kohsuke.stapler.DataBoundConstructor;

public class UpstreamCauseRestriction
extends JobCauseRestriction<Cause.UpstreamCause> {
    JobRestriction jobRestriction;
    final boolean skipCheckForMissingInfo;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public UpstreamCauseRestriction(JobRestriction jobRestriction, boolean skipCheckForMissingInfo) {
        this.jobRestriction = jobRestriction;
        this.skipCheckForMissingInfo = skipCheckForMissingInfo;
    }

    public UpstreamCauseRestriction(JobRestriction jobRestriction) {
        this(jobRestriction, false);
    }

    public JobRestriction getJobRestriction() {
        return this.jobRestriction;
    }

    public boolean isSkipCheckForMissingInfo() {
        return this.skipCheckForMissingInfo;
    }

    @Override
    public void validate(Cause.UpstreamCause cause) throws AbortException {
        Run upstreamRun = cause.getUpstreamRun();
        if (upstreamRun == null) {
            if (!this.skipCheckForMissingInfo) {
                throw new AbortException("Upstream build info is missing");
            }
            return;
        }
        if (this.jobRestriction != null && !this.jobRestriction.canTake(upstreamRun)) {
            throw new AbortException("Job can't be executed due to upstream restrictions");
        }
    }

    public Descriptor<JobCauseRestriction<? extends Cause>> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends JobCauseRestriction.JobCauseRestrictionDescriptor {
        public String getDisplayName() {
            return Messages.jobs_CauseRestrictions_Upstream();
        }
    }
}

