/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;

public final class ListAtEndFilter
implements BoilerpipeFilter {
    public static final ListAtEndFilter INSTANCE = new ListAtEndFilter();

    private ListAtEndFilter() {
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        int tagLevel = Integer.MAX_VALUE;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (tb.isContent() && tb.hasLabel("de.l3s.boilerpipe/VERY_LIKELY_CONTENT")) {
                tagLevel = tb.getTagLevel();
                continue;
            }
            if (tb.getTagLevel() > tagLevel && tb.hasLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT") && tb.hasLabel("de.l3s.boilerpipe/LI") && tb.getLinkDensity() == 0.0f) {
                tb.setIsContent(true);
                changes = true;
                continue;
            }
            tagLevel = Integer.MAX_VALUE;
        }
        return changes;
    }
}

