/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;

public final class LargeBlockSameTagLevelToContentFilter
implements BoilerpipeFilter {
    public static final LargeBlockSameTagLevelToContentFilter INSTANCE = new LargeBlockSameTagLevelToContentFilter();

    private LargeBlockSameTagLevelToContentFilter() {
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        int tagLevel = -1;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (!tb.isContent() || !tb.hasLabel("de.l3s.boilerpipe/VERY_LIKELY_CONTENT")) continue;
            tagLevel = tb.getTagLevel();
            break;
        }
        if (tagLevel == -1) {
            return false;
        }
        for (TextBlock tb : doc.getTextBlocks()) {
            if (tb.isContent() || tb.getNumWords() < 100 || tb.getTagLevel() != tagLevel) continue;
            tb.setIsContent(true);
            changes = true;
        }
        return changes;
    }
}

