/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.rabbitmq.http.client.domain;

import com.fasterxml.jackson.annotation.JsonProperty;

@SuppressWarnings("unused")
public class CurrentUserDetails {
  private String name;
  private String tags;
  @JsonProperty("auth_backend")
  private String authBackend;

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getTags() {
    return tags;
  }

  public void setTags(String tags) {
    this.tags = tags;
  }

  public String getAuthBackend() {
    return authBackend;
  }

  public void setAuthBackend(String authBackend) {
    this.authBackend = authBackend;
  }

  @Override
  public String toString() {
    return "CurrentUserDetails{" +
        "name='" + name + '\'' +
        ", tags='" + tags + '\'' +
        ", authBackend='" + authBackend + '\'' +
        '}';
  }
}
