/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.data.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class RMB {
    private double amount = 0.0;
    private static final String NUM = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
    private static final String UNIT = "\u4edf\u4f70\u62fe\u4e2a";
    private static final String GRADEUNIT = "\u4edf\u4e07\u4ebf\u5146";
    private static final String DOTUNIT = "\u89d2\u5206\u5398";
    private static final int GRADE = 4;
    private static final String SIGN = "\uffe5";
    private static final NumberFormat nf = new DecimalFormat("#0.###");

    public RMB(double amount) {
        this.amount = amount;
    }

    public String toBigAmt() {
        return RMB.toBigAmt(this.amount);
    }

    public static String toBigAmt(double amount) {
        String amt = nf.format(amount);
        Double d = new Double(amount);
        String dotPart = "";
        String intPart = "";
        int dotPos = amt.indexOf(46);
        if (dotPos != -1) {
            intPart = amt.substring(0, dotPos);
            dotPart = amt.substring(dotPos + 1);
        } else {
            intPart = amt;
        }
        if (intPart.length() > 16) {
            throw new InternalError("The amount is too big.");
        }
        String intBig = RMB.intToBig(intPart);
        String dotBig = RMB.dotToBig(dotPart);
        if (dotBig.length() == 0 && intBig.length() != 0) {
            return intBig + "\u5143\u6574";
        }
        if (dotBig.length() == 0 && intBig.length() == 0) {
            return intBig + "\u96f6\u5143";
        }
        if (dotBig.length() != 0 && intBig.length() != 0) {
            return intBig + "\u5143" + dotBig;
        }
        return dotBig;
    }

    private static String dotToBig(String dotPart) {
        String strRet = "";
        for (int i = 0; i < dotPart.length() && i < 3; ++i) {
            int num = Integer.parseInt(dotPart.substring(i, i + 1));
            if (num == 0) continue;
            strRet = strRet + NUM.substring(num, num + 1) + DOTUNIT.substring(i, i + 1);
        }
        return strRet;
    }

    private static String intToBig(String intPart) {
        String result = "";
        String strTmp = "";
        int grade = intPart.length() / 4;
        if (intPart.length() % 4 != 0) {
            ++grade;
        }
        for (int i = grade; i >= 1; --i) {
            strTmp = RMB.getNowGradeVal(intPart, i);
            result = result + RMB.getSubUnit(strTmp);
            result = RMB.dropZero(result);
            if (i <= 1) continue;
            result = RMB.getSubUnit(strTmp).equals("\u96f6\u96f6\u96f6\u96f6") ? result + "\u96f6" + GRADEUNIT.substring(i - 1, i) : result + GRADEUNIT.substring(i - 1, i);
        }
        return result;
    }

    private static String getNowGradeVal(String strVal, int grade) {
        String rst = strVal.length() <= grade * 4 ? strVal.substring(0, strVal.length() - (grade - 1) * 4) : strVal.substring(strVal.length() - grade * 4, strVal.length() - (grade - 1) * 4);
        return rst;
    }

    private static String getSubUnit(String strVal) {
        String rst = "";
        for (int i = 0; i < strVal.length(); ++i) {
            String s = strVal.substring(i, i + 1);
            int num = Integer.parseInt(s);
            if (num == 0) {
                if (i == strVal.length()) continue;
                rst = rst + "\u96f6";
                continue;
            }
            rst = rst + NUM.substring(num, num + 1);
            if (i == strVal.length() - 1) continue;
            rst = rst + UNIT.substring(i + 4 - strVal.length(), i + 4 - strVal.length() + 1);
        }
        return rst;
    }

    private static String dropZero(String strVal) {
        String strBefore;
        String strRst = strBefore = strVal.substring(0, 1);
        for (int i = 1; i < strVal.length(); ++i) {
            String strNow = strVal.substring(i, i + 1);
            if (!strNow.equals("\u96f6") || !strBefore.equals("\u96f6")) {
                strRst = strRst + strNow;
            }
            strBefore = strNow;
        }
        if (strRst.substring(strRst.length() - 1, strRst.length()).equals("\u96f6")) {
            strRst = strRst.substring(0, strRst.length() - 1);
        }
        return strRst;
    }

    public static void main(String[] args) {
        System.out.println(RMB.toBigAmt(1.0052345E7));
        System.out.println(RMB.toBigAmt(0.0));
        System.out.println(RMB.toBigAmt(0.6));
        System.out.println(RMB.toBigAmt(0.6));
        System.out.println(RMB.toBigAmt(150.2101));
        System.out.println(RMB.toBigAmt(1.5400089666234E10));
        System.out.println(RMB.toBigAmt(2.22000044442347E10));
    }
}

