/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.data.utils;

import com.quhaodian.data.page.Condition;
import com.quhaodian.data.page.Filter;
import com.quhaodian.data.page.Search;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FilterUtils {
    public static List<Filter> getFilters(Object search) {
        Field[] fields;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (search == null) {
            return filters;
        }
        for (Field field : fields = search.getClass().getDeclaredFields()) {
            Search item = field.getAnnotation(Search.class);
            if (item == null) continue;
            field.setAccessible(true);
            try {
                Filter filter;
                Object object = field.get(search);
                if (object == null) continue;
                if (object instanceof String) {
                    String oString = (String)object;
                    if (StringUtils.isBlank((CharSequence)oString)) continue;
                    object = oString.trim();
                }
                if (item.operator() == Filter.Operator.like) {
                    filter = new Filter(item.name(), item.operator(), "%" + object + "%");
                    filter.setPrefix(item.prefix());
                } else {
                    filter = new Filter(item.name(), item.operator(), object);
                    filter.setPrefix(item.prefix());
                }
                if (item.condition() == Condition.AND) {
                    filter.setCondition("and");
                } else {
                    filter.setCondition("or");
                }
                filters.add(filter);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return filters;
    }
}

