/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.data.page;

import com.quhaodian.data.page.Filter;
import com.quhaodian.data.page.Order;
import com.quhaodian.data.page.Pageable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = -2053800594583879853L;
    private final List<T> content = new ArrayList<T>();
    private final long total;
    private final Pageable pageable;
    private int splitSize = 3;

    public Page() {
        this.total = 0L;
        this.pageable = new Pageable();
    }

    public Page(List<T> content, long total, Pageable pageable) {
        this.content.addAll(content);
        this.total = total;
        this.pageable = pageable;
    }

    public int getPageNumber() {
        return this.pageable.getPageNumber();
    }

    public int getNo() {
        return this.pageable.getNo();
    }

    public int getPageSize() {
        return this.pageable.getPageSize();
    }

    public int getSize() {
        return this.pageable.getSize();
    }

    public String getSearchProperty() {
        return this.pageable.getSearchProperty();
    }

    public String getSearchValue() {
        return this.pageable.getSearchValue();
    }

    public String getOrderProperty() {
        return this.pageable.getOrderProperty();
    }

    public Order.Direction getOrderDirection() {
        return this.pageable.getOrderDirection();
    }

    public List<Order> getOrders() {
        return this.pageable.getOrders();
    }

    public List<Filter> getFilters() {
        return this.pageable.getFilters();
    }

    public int getTotalPages() {
        return (int)Math.ceil((double)this.getTotal() / (double)this.getPageSize());
    }

    public List<T> getContent() {
        return this.content;
    }

    public long getTotal() {
        return this.total;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public int getFirstNo() {
        int num;
        int result = 1;
        result = this.getPageNumber() - this.splitSize;
        int t = this.getEndNo() - result;
        if (t < (num = this.splitSize * 2)) {
            result -= num - t;
        }
        if (result <= 0) {
            result = 1;
        }
        return result;
    }

    public int getEndNo() {
        int result = 1;
        result = this.getPageNumber() + this.splitSize;
        if (this.getPageNumber() <= this.splitSize) {
            result = result + this.splitSize - this.getPageNumber();
            ++result;
        }
        if (result > this.getTotalPages()) {
            result = this.getTotalPages();
        }
        return result;
    }
}

