/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.data.page;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Filter
implements Serializable {
    private static final long serialVersionUID = -8712382358441065075L;
    private static final boolean DEFAULT_IGNORE_CASE = false;
    private String property;
    private Operator operator;
    private Object value;
    private String condition = "and";
    private String prefix = "";
    private Boolean ignoreCase = false;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Filter() {
    }

    public Filter(String property, Operator operator, Object value) {
        this.property = property;
        this.operator = operator;
        this.value = value;
    }

    public Filter(String property, Operator operator, Object value, boolean ignoreCase) {
        this.property = property;
        this.operator = operator;
        this.value = value;
        this.ignoreCase = ignoreCase;
    }

    public static Filter eq(String property, Object value) {
        return new Filter(property, Operator.eq, value);
    }

    public static Filter eq(String property, Object value, boolean ignoreCase) {
        return new Filter(property, Operator.eq, value, ignoreCase);
    }

    public static Filter ne(String property, Object value) {
        return new Filter(property, Operator.ne, value);
    }

    public static Filter ne(String property, Object value, boolean ignoreCase) {
        return new Filter(property, Operator.ne, value, ignoreCase);
    }

    public static Filter gt(String property, Object value) {
        return new Filter(property, Operator.gt, value);
    }

    public static Filter lt(String property, Object value) {
        return new Filter(property, Operator.lt, value);
    }

    public static Filter ge(String property, Object value) {
        return new Filter(property, Operator.ge, value);
    }

    public static Filter le(String property, Object value) {
        return new Filter(property, Operator.le, value);
    }

    public static Filter like(String property, Object value) {
        return new Filter(property, Operator.like, value);
    }

    public static Filter in(String property, Object value) {
        return new Filter(property, Operator.in, value);
    }

    public static Filter isNull(String property) {
        return new Filter(property, Operator.isNull, null);
    }

    public static Filter isNotNull(String property) {
        return new Filter(property, Operator.isNotNull, null);
    }

    public Filter ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Filter other = (Filter)obj;
        return new EqualsBuilder().append((Object)this.getProperty(), (Object)other.getProperty()).append((Object)this.getOperator(), (Object)other.getOperator()).append(this.getValue(), other.getValue()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getProperty()).append((Object)this.getOperator()).append(this.getValue()).toHashCode();
    }

    public String toString() {
        return "Filter [property=" + this.property + ", operator=" + (Object)((Object)this.operator) + ", value=" + this.value + ", ignoreCase=" + this.ignoreCase + "]";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public static enum Operator {
        eq,
        ne,
        gt,
        lt,
        ge,
        le,
        like,
        in,
        isNull,
        isNotNull;


        public static Operator fromString(String value) {
            return Operator.valueOf(value.toLowerCase());
        }
    }
}

