/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.data.core;

import com.quhaodian.data.core.Paginable;
import com.quhaodian.data.core.SimplePage;
import java.io.Serializable;
import java.util.List;

public class Pagination<T>
extends SimplePage
implements Serializable,
Paginable {
    int size = 2;
    private List<T> list;

    public Pagination() {
    }

    public Pagination(int pageNo, int pageSize, int totalCount) {
        super(pageNo, pageSize, totalCount);
    }

    public Pagination(int pageNo, int pageSize, int totalCount, List<T> list) {
        super(pageNo, pageSize, totalCount);
        this.list = list;
    }

    public int getFirstResult() {
        return (this.pageNo - 1) * this.pageSize;
    }

    public int getFirstNo() {
        int num;
        int result = 1;
        result = this.pageNo - this.size;
        int t = this.getEndNo() - result;
        if (t < (num = this.size * 2)) {
            result -= num - t;
        }
        if (result <= 0) {
            result = 1;
        }
        return result;
    }

    public int getEndNo() {
        int result = 1;
        result = this.getPageNo() + this.size;
        if (this.getPageNo() <= this.size) {
            result = result + this.size - this.getPageNo();
            ++result;
        }
        if (result > this.getTotalPage()) {
            result = this.getTotalPage();
        }
        return result;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List list) {
        this.list = list;
    }

    public String toString() {
        return "Pagination [totalCount=" + this.totalCount + ", pageSize=" + this.pageSize + ", pageNo=" + this.pageNo + "]";
    }

    public static void main(String[] args) {
        Pagination p = new Pagination(9, 10, 100);
        System.out.println(p.getFirstNo());
        System.out.println(p.getEndNo());
        System.out.println(p.getPageNo());
        System.out.println(p.getNextPage());
        System.out.println(p.getPrePage());
        System.out.println(p.getTotalPage());
    }
}

