/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.data.core;

import com.quhaodian.data.core.BaseDaoImpl;
import com.quhaodian.data.core.CriteriaDao;
import com.quhaodian.data.page.Filter;
import com.quhaodian.data.page.Order;
import com.quhaodian.data.page.Page;
import com.quhaodian.data.page.Pageable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public abstract class CriteriaDaoImpl<T, ID extends Serializable>
extends BaseDaoImpl<T, ID>
implements CriteriaDao<T, ID> {
    @Override
    public Page<T> findPage(Pageable pageable) {
        Criteria criteriaBuilder = this.createCriteria(new Criterion[0]);
        return this.findPage(criteriaBuilder, pageable);
    }

    @Override
    public List<T> findList(Integer first, Integer count, List<Filter> filters, List<Order> orders) {
        Criteria criteriaBuilder = this.createCriteria(new Criterion[0]);
        this.addRestrictions(criteriaBuilder, filters);
        this.addOrders(criteriaBuilder, orders);
        if (first != null) {
            criteriaBuilder.setFirstResult(first.intValue());
        }
        if (count != null) {
            criteriaBuilder.setMaxResults(count.intValue());
        }
        return criteriaBuilder.list();
    }

    private void addOrders(Criteria criteriaQuery, List<Order> orders) {
        if (criteriaQuery == null || orders == null || orders.isEmpty()) {
            return;
        }
        for (Order order : orders) {
            if (order.getDirection() == Order.Direction.asc) {
                criteriaQuery.addOrder(org.hibernate.criterion.Order.asc((String)order.getProperty()));
                continue;
            }
            if (order.getDirection() != Order.Direction.desc) continue;
            criteriaQuery.addOrder(org.hibernate.criterion.Order.desc((String)order.getProperty()));
        }
    }

    protected Page<T> findPage(Criteria criteriaQuery, Pageable pageable) {
        Long total;
        if (pageable == null) {
            pageable = new Pageable();
        }
        Criteria countQuery = this.createCriteria(new Criterion[0]);
        if (StringUtils.isNotEmpty((CharSequence)pageable.getSearchProperty()) && StringUtils.isNotEmpty((CharSequence)pageable.getSearchValue())) {
            countQuery.add((Criterion)Restrictions.like((String)pageable.getSearchProperty(), (Object)("%" + pageable.getSearchValue() + "%")));
        }
        if ((total = this.count(countQuery, pageable.getFilters())) == null) {
            total = 0L;
        }
        if (StringUtils.isNotEmpty((CharSequence)pageable.getSearchProperty()) && StringUtils.isNotEmpty((CharSequence)pageable.getSearchValue())) {
            criteriaQuery.add((Criterion)Restrictions.like((String)pageable.getSearchProperty(), (Object)("%" + pageable.getSearchValue() + "%")));
        }
        this.addRestrictions(criteriaQuery, pageable.getFilters());
        int totalPages = (int)Math.ceil((double)total.longValue() / (double)pageable.getPageSize());
        if (totalPages < pageable.getPageNumber()) {
            pageable.setPageNumber(totalPages);
        }
        if (StringUtils.isNotEmpty((CharSequence)pageable.getSearchAliasProperty()) && pageable.getSearchAliasValue() == null) {
            criteriaQuery.createAlias(pageable.getSearchAliasProperty().split("[.]")[0], pageable.getSearchAliasProperty().split("[.]")[0]).add(Restrictions.isNotNull((String)pageable.getSearchAliasProperty()));
        }
        if (StringUtils.isNotEmpty((CharSequence)pageable.getSearchAliasProperty()) && pageable.getSearchAliasValue() != null) {
            criteriaQuery.createAlias(pageable.getSearchAliasProperty().split("[.]")[0], pageable.getSearchAliasProperty().split("[.]")[0]).add((Criterion)Restrictions.eq((String)pageable.getSearchAliasProperty(), (Object)pageable.getSearchAliasValue()));
        }
        this.addOrders(criteriaQuery, pageable);
        criteriaQuery.setFirstResult((pageable.getPageNumber() - 1) * pageable.getPageSize());
        criteriaQuery.setMaxResults(pageable.getPageSize());
        return new Page(criteriaQuery.list(), total, pageable);
    }

    @Override
    public long count(Filter ... filters) {
        Criteria criteriaBuilder = this.createCriteria(new Criterion[0]);
        return this.count(criteriaBuilder, filters != null ? Arrays.asList(filters) : null);
    }

    private void addOrders(Criteria criteriaQuery, Pageable pageable) {
        if (criteriaQuery == null || pageable == null) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)pageable.getOrderProperty()) && pageable.getOrderDirection() != null) {
            if (pageable.getOrderDirection() == Order.Direction.asc) {
                criteriaQuery.addOrder(org.hibernate.criterion.Order.asc((String)pageable.getOrderProperty()));
            } else if (pageable.getOrderDirection() == Order.Direction.desc) {
                criteriaQuery.addOrder(org.hibernate.criterion.Order.desc((String)pageable.getOrderProperty()));
            }
        }
        if (pageable.getOrders() != null) {
            for (Order order : pageable.getOrders()) {
                if (order.getDirection() == Order.Direction.asc) {
                    criteriaQuery.addOrder(org.hibernate.criterion.Order.asc((String)order.getProperty()));
                    continue;
                }
                if (order.getDirection() != Order.Direction.desc) continue;
                criteriaQuery.addOrder(org.hibernate.criterion.Order.desc((String)order.getProperty()));
            }
        }
    }

    protected Long count(Criteria criteriaQuery, List<Filter> filters) {
        this.addRestrictions(criteriaQuery, filters);
        criteriaQuery.setProjection(Projections.rowCount());
        return (Long)criteriaQuery.uniqueResult();
    }

    private void addRestrictions(Criteria criteriaQuery, List<Filter> filters) {
        if (criteriaQuery == null || filters == null || filters.isEmpty()) {
            return;
        }
        for (Filter filter : filters) {
            if (filter == null || StringUtils.isEmpty((CharSequence)filter.getProperty())) continue;
            if (filter.getOperator() == Filter.Operator.eq && filter.getValue() != null) {
                criteriaQuery.add((Criterion)Restrictions.eq((String)filter.getProperty(), (Object)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.ne && filter.getValue() != null) {
                criteriaQuery.add((Criterion)Restrictions.ne((String)filter.getProperty(), (Object)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.gt && filter.getValue() != null) {
                criteriaQuery.add((Criterion)Restrictions.gt((String)filter.getProperty(), (Object)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.lt && filter.getValue() != null) {
                criteriaQuery.add((Criterion)Restrictions.lt((String)filter.getProperty(), (Object)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.ge && filter.getValue() != null) {
                criteriaQuery.add((Criterion)Restrictions.ge((String)filter.getProperty(), (Object)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.le && filter.getValue() != null) {
                criteriaQuery.add((Criterion)Restrictions.le((String)filter.getProperty(), (Object)filter.getValue()));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.like && filter.getValue() != null && filter.getValue() instanceof String) {
                criteriaQuery.add((Criterion)Restrictions.like((String)filter.getProperty(), (String)((String)filter.getValue()), (MatchMode)MatchMode.ANYWHERE));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.in && filter.getValue() != null) {
                if (!(filter.getValue() instanceof Collection)) continue;
                criteriaQuery.add(Restrictions.in((String)filter.getProperty(), (Collection)((Collection)filter.getValue())));
                continue;
            }
            if (filter.getOperator() == Filter.Operator.isNull) {
                criteriaQuery.add(Restrictions.isNull((String)filter.getProperty()));
                continue;
            }
            if (filter.getOperator() != Filter.Operator.isNotNull) continue;
            criteriaQuery.add(Restrictions.isNotNull((String)filter.getProperty()));
        }
    }
}

