/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.data.core;

import com.quhaodian.data.core.BaseDao;
import com.quhaodian.data.core.Finder;
import com.quhaodian.data.core.MyBeanUtils;
import com.quhaodian.data.core.Pagination;
import com.quhaodian.data.core.Updater;
import com.quhaodian.data.page.Filter;
import com.quhaodian.data.page.Order;
import com.quhaodian.data.page.Page;
import com.quhaodian.data.page.Pageable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.ast.QueryTranslatorImpl;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;
import org.springframework.util.Assert;

public abstract class BaseDaoImpl<T, ID extends Serializable>
extends HibernateDaoSupport
implements BaseDao<T, ID> {
    protected static final String ORDER_ENTRIES = "orderEntries";

    @Override
    public List<T> list(Pageable pageable) {
        List result = null;
        List<Filter> filters = pageable.getFilters();
        List<Order> orders = pageable.getOrders();
        Finder finder = this.makeFinder(filters, orders);
        result = this.find(finder);
        return result;
    }

    @Override
    public List<T> filters(Filter ... filters) {
        List result = new ArrayList();
        if (filters != null && filters.length > 0) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            for (Filter item : filters) {
                filterList.add(item);
            }
            result = this.find(this.makeFinder(filterList, null));
        }
        return result;
    }

    @Override
    public T add(T t) {
        if (t == null) {
            return null;
        }
        this.getHibernateTemplate().save(t);
        return t;
    }

    protected int countByProperty(String property, Object value) {
        Assert.hasText((String)property, (String)"\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)value, (String)"\u4e0d\u80fd\u4e3a\u7a7a");
        return ((Number)this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).setProjection(Projections.rowCount()).uniqueResult()).intValue();
    }

    @Override
    public Long countQuery(Finder finder) {
        Long result = 0L;
        try {
            Query query = this.getSessionFactory().getCurrentSession().createQuery(finder.getRowCountHql());
            finder.setParamsToQuery(query);
            if (finder.isCacheable()) {
                query.setCacheable(true);
            }
            result = ((Number)query.iterate().next()).longValue();
        }
        catch (Exception e) {
            this.logger.error((Object)("" + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public Long countQuery(Filter ... filters) {
        Long result = 0L;
        try {
            if (filters != null && filters.length > 0) {
                ArrayList<Filter> filterList = new ArrayList<Filter>();
                for (Filter item : filters) {
                    filterList.add(item);
                }
                result = this.countQuery(this.makeFinder(filterList, null));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("" + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public int countQueryResult(Finder finder) {
        int result = 0;
        try {
            Query query = this.getSessionFactory().getCurrentSession().createQuery(finder.getRowCountHql());
            finder.setParamsToQuery(query);
            if (finder.isCacheable()) {
                query.setCacheable(true);
            }
            result = ((Number)query.iterate().next()).intValue();
        }
        catch (Exception e) {
            this.logger.error((Object)("" + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    @Override
    public int countQuerySqlResult(Finder finder) {
        List ls;
        Object o;
        NativeQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(finder.getRowCountHql());
        finder.setParamsToQuery((Query)query);
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        if ((o = (ls = query.list()).get(0)) instanceof Number) {
            return ((Number)o).intValue();
        }
        return 0;
    }

    protected Criteria createCriteria(Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(this.getEntityClass());
        for (Criterion c : criterions) {
            criteria.add(c);
        }
        return criteria;
    }

    protected Query createQuery(String queryString, Object ... values) {
        Assert.hasText((String)queryString);
        Query queryObject = this.getSessionFactory().getCurrentSession().createQuery(queryString);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                queryObject.setParameter(i, values[i]);
            }
        }
        return queryObject;
    }

    @Override
    public T delete(T t) {
        if (t == null) {
            return null;
        }
        this.getHibernateTemplate().delete(t);
        return t;
    }

    @Override
    public List find(String hql, Object ... values) {
        return this.createQuery(hql, values).list();
    }

    @Override
    public Pagination<T> find(Finder finder, int pageNo, int pageSize) {
        int totalCount = this.countQueryResult(finder);
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        if (p.getPageNo() < pageNo) {
            p.setList(new ArrayList());
            return p;
        }
        Query query = this.getSessionFactory().getCurrentSession().createQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        query.setFirstResult(p.getFirstResult());
        query.setMaxResults(p.getPageSize());
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        List list = query.list();
        p.setList(list);
        return p;
    }

    @Override
    public List find(Finder finder) {
        Query query = finder.createQuery(this.getSessionFactory().getCurrentSession());
        List list = query.list();
        return list;
    }

    public List findByCriteria(Criterion ... criterion) {
        return this.createCriteria(criterion).list();
    }

    @Override
    public Pagination findByCriteria(Criteria crit, int pageNo, int pageSize) {
        List orderEntries;
        CriteriaImpl impl = (CriteriaImpl)crit;
        Projection projection = impl.getProjection();
        ResultTransformer transformer = impl.getResultTransformer();
        try {
            orderEntries = (List)MyBeanUtils.getFieldValue(impl, ORDER_ENTRIES);
            MyBeanUtils.setFieldValue(impl, ORDER_ENTRIES, new ArrayList());
        }
        catch (Exception e) {
            throw new RuntimeException("cannot read/write 'orderEntries' from CriteriaImpl", e);
        }
        int totalCount = ((Number)crit.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        crit.setProjection(projection);
        if (projection == null) {
            crit.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        if (transformer != null) {
            crit.setResultTransformer(transformer);
        }
        try {
            MyBeanUtils.setFieldValue(impl, ORDER_ENTRIES, orderEntries);
        }
        catch (Exception e) {
            throw new RuntimeException("set 'orderEntries' to CriteriaImpl faild", e);
        }
        crit.setFirstResult(p.getFirstResult());
        crit.setMaxResults(p.getPageSize());
        p.setList(crit.list());
        return p;
    }

    @Override
    public Pagination<T> findByPage(Pageable pageable) {
        List<Filter> filters = pageable.getFilters();
        List<Order> orders = pageable.getOrders();
        Finder finder = this.makeFinder(filters, orders);
        Pagination<T> page = this.find(finder, pageable.getPageNumber(), pageable.getPageSize());
        return page;
    }

    @Override
    public List<T> findByProperty(String property, Object value) {
        Assert.hasText((String)property);
        return this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).list();
    }

    @Override
    public T findOne(Finder finder) {
        T entity = null;
        List list = this.find(finder);
        if (list != null && list.size() > 0) {
            entity = (T)list.get(0);
        }
        return entity;
    }

    @Override
    public <DTO> Pagination<DTO> findSql(Finder finder, int pageNo, int pageSize, Class<DTO> otoclass) {
        int totalCount = this.countQuerySqlResult(finder);
        Pagination p = new Pagination(pageNo, pageSize, totalCount);
        if (totalCount < 1) {
            p.setList(new ArrayList());
            return p;
        }
        if (p.getPageNo() < pageNo) {
            p.setList(new ArrayList());
            return p;
        }
        NativeQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(finder.getOrigHql());
        finder.setParamsToQuery((Query)query);
        query.setFirstResult(p.getFirstResult());
        query.setMaxResults(p.getPageSize());
        query.setResultTransformer(Transformers.aliasToBean(otoclass));
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        List list = query.list();
        p.setList(list);
        return p;
    }

    protected Object findUnique(String hql, Object ... values) {
        return this.createQuery(hql, values).uniqueResult();
    }

    protected T findUniqueByProperty(String property, Object value) {
        Assert.hasText((String)property, (String)"\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)value, (String)"\u4e0d\u80fd\u4e3a\u7a7a");
        return (T)this.createCriteria(new Criterion[]{Restrictions.eq((String)property, (Object)value)}).uniqueResult();
    }

    protected T get(ID id) {
        return this.get(id, false);
    }

    protected T get(ID id, boolean lock) {
        Object entity = lock ? this.getSession().get(this.getEntityClass(), id, LockMode.UPGRADE) : this.getSession().get(this.getEntityClass(), id);
        return (T)entity;
    }

    protected abstract Class<T> getEntityClass();

    private String getProperty(Filter filter) {
        String result = filter.getProperty();
        result = result.replaceAll("\\.", "");
        return result;
    }

    protected Session getSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    @Override
    public <DTO> DTO hql(Finder finder) {
        Object o;
        Query query = this.getSessionFactory().getCurrentSession().createQuery(finder.getOrigHql());
        finder.setParamsToQuery(query);
        if (finder.isCacheable()) {
            query.setCacheable(true);
        }
        List ls = query.list();
        Object result = o = ls.get(0);
        return (DTO)result;
    }

    @Override
    public List<T> list(Integer first, Integer count, List<Filter> filters, List<Order> orders) {
        List result = null;
        Finder finder = this.makeFinder(filters, orders);
        finder.setFirstResult(first);
        finder.setMaxResults(count);
        result = this.find(finder);
        return result;
    }

    @Override
    public <DTO> List<DTO> listSQL(String sql, Class<DTO> otoclass) {
        List result = null;
        NativeQuery query = this.getSessionFactory().getCurrentSession().createNativeQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(otoclass));
        result = query.list();
        return result;
    }

    @Override
    public <DTO> List<DTO> listSQL(String sql, Integer stat, Integer max, Class<DTO> otoclass) {
        List result = null;
        NativeQuery query = this.getSessionFactory().getCurrentSession().createNativeQuery(sql);
        query.setResultTransformer(Transformers.aliasToBean(otoclass));
        query.setFirstResult(stat.intValue());
        query.setMaxResults(max.intValue());
        result = query.list();
        return result;
    }

    protected Finder makeFinder(List<Filter> filters, List<Order> orders) {
        Finder finder = Finder.create();
        finder.append("select distinct model from " + this.getEntityClass().getSimpleName());
        if (filters == null || filters.isEmpty()) {
            finder.append(" model ");
        } else {
            finder.append(" model where ");
        }
        this.makerFilter(filters, finder);
        this.makeOrder(orders, finder);
        return finder;
    }

    private void makeOrder(List<Order> orders, Finder finder) {
        if (orders != null && !orders.isEmpty()) {
            finder.append(" order by ");
            int num = 0;
            int all = orders.size();
            for (Order order : orders) {
                ++num;
                finder.append(" model." + order.getProperty());
                if (order.getDirection() == Order.Direction.asc) {
                    finder.append(" asc ");
                } else {
                    finder.append(" desc ");
                }
                if (num == all) continue;
                finder.append(" , ");
            }
        }
    }

    private void makerFilter(List<Filter> filters, Finder finder) {
        if (filters != null) {
            int i = 0;
            for (Filter filter : filters) {
                if (i == 0) {
                    finder.append(" model." + filter.getProperty());
                } else {
                    finder.append(" " + filter.getCondition() + "  model." + filter.getProperty());
                }
                String cname = filter.getPrefix() + this.getProperty(filter);
                if (filter.getOperator() == Filter.Operator.eq) {
                    finder.append(" =:" + cname);
                } else if (filter.getOperator() == Filter.Operator.ne) {
                    finder.append(" !=:" + cname);
                } else if (filter.getOperator() == Filter.Operator.ge) {
                    finder.append(" >=:" + cname);
                } else if (filter.getOperator() == Filter.Operator.gt) {
                    finder.append(" >:" + cname);
                } else if (filter.getOperator() == Filter.Operator.le) {
                    finder.append(" <=:" + cname);
                } else if (filter.getOperator() == Filter.Operator.lt) {
                    finder.append(" <:" + cname);
                } else if (filter.getOperator() == Filter.Operator.like) {
                    finder.append(" like:" + cname);
                } else if (filter.getOperator() == Filter.Operator.isNull) {
                    finder.append(" is null ");
                } else if (filter.getOperator() == Filter.Operator.isNotNull) {
                    finder.append(" is not null  ");
                }
                if (filter.getOperator() == Filter.Operator.like) {
                    finder.setParam(cname, "%" + filter.getValue() + "%");
                } else if (filter.getOperator() != Filter.Operator.isNotNull && filter.getOperator() != Filter.Operator.isNull) {
                    finder.setParam(cname, filter.getValue());
                }
                ++i;
            }
        }
    }

    @Override
    public T merge(T t) {
        this.getHibernateTemplate().merge(t);
        return t;
    }

    @Override
    public <DTO> DTO oneSQL(String sql, Class<DTO> otoclass) {
        DTO result = null;
        List<DTO> results = this.listSQL(sql, 0, 2, otoclass);
        if (results != null && !results.isEmpty()) {
            result = results.get(0);
        }
        return result;
    }

    @Override
    public Page<T> page(Pageable pageable) {
        Page<T> result = null;
        List<Filter> filters = pageable.getFilters();
        List<Order> orders = pageable.getOrders();
        Finder finder = this.makeFinder(filters, orders);
        Pagination<T> page = this.find(finder, pageable.getPageNumber(), pageable.getPageSize());
        result = new Page<T>(page.getList(), page.getTotalCount(), pageable);
        return result;
    }

    @Override
    public String transHqlToSql(String hql) {
        if (hql == null || hql.equals("")) {
            return null;
        }
        Session session = this.getSession();
        SessionFactoryImpl sfi = (SessionFactoryImpl)session.getSessionFactory();
        QueryTranslatorImpl queryTranslator = new QueryTranslatorImpl(hql, hql, Collections.emptyMap(), (SessionFactoryImplementor)sfi);
        queryTranslator.compile(Collections.emptyMap(), false);
        return queryTranslator.getSQLString();
    }

    @Override
    public T update(T t) {
        if (t == null) {
            return null;
        }
        this.getHibernateTemplate().update(t);
        return t;
    }

    public T updateByUpdater(Updater<T> updater) {
        ClassMetadata cm = this.getSessionFactory().getClassMetadata(this.getEntityClass());
        T bean = updater.getBean();
        Object po = this.getSession().get(this.getEntityClass(), cm.getIdentifier(bean));
        this.updaterCopyToPersistentObject(updater, po, cm);
        return (T)po;
    }

    private void updaterCopyToPersistentObject(Updater<T> updater, T po, ClassMetadata cm) {
        String[] propNames = cm.getPropertyNames();
        String identifierName = cm.getIdentifierPropertyName();
        T bean = updater.getBean();
        for (String propName : propNames) {
            if (propName.equals(identifierName)) continue;
            try {
                Object value = MyBeanUtils.getSimpleProperty(bean, propName);
                if (!updater.isUpdate(propName, value)) continue;
                cm.setPropertyValue(po, propName, value);
            }
            catch (Exception e) {
                throw new RuntimeException("copy property to persistent object failed: '" + propName + "'", e);
            }
        }
    }
}

