/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.common.utils;

import freemarker.core.Environment;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.support.RequestContext;

public abstract class DirectiveUtils {
    public static final String OUT_BEAN = "tag_bean";
    public static final String OUT_LIST = "tag_list";
    public static final String OUT_PAGINATION = "tag_pagination";
    public static final String PARAM_TPL = "tpl";
    public static final String PARAM_TPL_SUB = "tplSub";

    public static Map<String, TemplateModel> addParamsToVariable(Environment env, Map<String, TemplateModel> params) throws TemplateException {
        HashMap<String, TemplateModel> origMap = new HashMap<String, TemplateModel>();
        if (params.size() <= 0) {
            return origMap;
        }
        Set<Map.Entry<String, TemplateModel>> entrySet = params.entrySet();
        for (Map.Entry<String, TemplateModel> entry : entrySet) {
            String key = entry.getKey();
            TemplateModel value = env.getVariable(key);
            if (value != null) {
                origMap.put(key, value);
            }
            env.setVariable(key, entry.getValue());
        }
        return origMap;
    }

    public static void removeParamsFromVariable(Environment env, Map<String, TemplateModel> params, Map<String, TemplateModel> origMap) throws TemplateException {
        if (params.size() <= 0) {
            return;
        }
        for (String key : params.keySet()) {
            env.setVariable(key, origMap.get(key));
        }
    }

    public static RequestContext getContext(Environment env) throws TemplateException {
        TemplateModel ctx = env.getGlobalVariable("springMacroRequestContext");
        if (ctx instanceof AdapterTemplateModel) {
            return (RequestContext)((AdapterTemplateModel)ctx).getAdaptedObject(RequestContext.class);
        }
        throw new TemplateModelException("RequestContext 'springMacroRequestContext' not found in DataModel.");
    }

    public static Integer getInt(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            String s = ((TemplateScalarModel)model).getAsString();
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().intValue();
        }
        return 0;
    }

    public static String getString(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)model).getAsString();
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().toString();
        }
        return "";
    }

    public static Date getDate(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateDateModel) {
            return ((TemplateDateModel)model).getAsDate();
        }
        return null;
    }

    public static Long getLong(String name, Map<String, TemplateModel> params) throws TemplateException {
        TemplateModel model = params.get(name);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            String s = ((TemplateScalarModel)model).getAsString();
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().longValue();
        }
        return 0L;
    }

    public static enum InvokeType {
        body,
        custom,
        sysDefined,
        userDefined;

    }
}

