/*
 * Decompiled with CFR 0.152.
 */
package com.quhaodian.common.freemarker;

import com.quhaodian.common.utils.DirectiveUtils;
import freemarker.core.Environment;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ListDirective<T>
implements TemplateDirectiveModel {
    private Map map;

    public void execute(Environment env, Map params, TemplateModel[] templateModels, TemplateDirectiveBody body) throws TemplateException, IOException {
        this.map = params;
        HashMap<String, TemplateModel> paramWrap = new HashMap<String, TemplateModel>(params);
        paramWrap.put("list", ObjectWrapper.DEFAULT_WRAPPER.wrap(this.list()));
        Map<String, TemplateModel> origMap = DirectiveUtils.addParamsToVariable(env, paramWrap);
        if (body != null) {
            body.render(env.getOut());
        }
        DirectiveUtils.removeParamsFromVariable(env, paramWrap, origMap);
    }

    public abstract List<T> list();

    private Map getParams() {
        return this.map;
    }

    public Integer getInt(String name) {
        Integer size = null;
        try {
            size = DirectiveUtils.getInt(name, this.map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public Integer getInt(String name, Integer num) {
        Integer size = null;
        try {
            size = DirectiveUtils.getInt(name, this.map);
            if (size == null) {
                size = num;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public Long getLong(String name, Long num) {
        Long size = null;
        try {
            size = DirectiveUtils.getLong(name, this.map);
            if (size == null) {
                size = num;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return size;
    }

    public String getString(String name, String defaul) {
        String result = null;
        try {
            result = DirectiveUtils.getString(name, this.map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaul == null) {
            defaul = "";
        }
        if (result == null) {
            result = defaul;
        }
        return result;
    }
}

