/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.TransferStateChangeListener;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.PauseException;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.transfer.AbstractTransfer;
import com.qcloud.cos.transfer.PauseResult;
import com.qcloud.cos.transfer.PauseStatus;
import com.qcloud.cos.transfer.PersistableUpload;
import com.qcloud.cos.transfer.TransferProgress;
import com.qcloud.cos.transfer.Upload;
import com.qcloud.cos.transfer.UploadMonitor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class UploadImpl
extends AbstractTransfer
implements Upload {
    private boolean isResumeableMultipartUploadAfterFailed = false;
    private PersistableUpload persistableUploadInfo = null;

    public UploadImpl(String description, TransferProgress transferProgressInternalState, ProgressListenerChain progressListenerChain, TransferStateChangeListener listener) {
        super(description, transferProgressInternalState, progressListenerChain, listener);
    }

    @Override
    public UploadResult waitForUploadResult() throws CosClientException, CosServiceException, InterruptedException {
        try {
            UploadResult result = null;
            while (!this.monitor.isDone() || result == null) {
                Future<?> f = this.monitor.getFuture();
                result = (UploadResult)f.get();
            }
            return result;
        }
        catch (ExecutionException e) {
            this.rethrowExecutionException(e);
            return null;
        }
    }

    @Override
    public PersistableUpload pause() throws PauseException {
        PauseResult<PersistableUpload> pauseResult = this.pause(true);
        if (pauseResult.getPauseStatus() != PauseStatus.SUCCESS) {
            throw new PauseException(pauseResult.getPauseStatus());
        }
        return pauseResult.getInfoToResume();
    }

    private PauseResult<PersistableUpload> pause(boolean forceCancelTransfers) throws CosClientException {
        UploadMonitor uploadMonitor = (UploadMonitor)this.monitor;
        return uploadMonitor.pause(forceCancelTransfers);
    }

    @Override
    public PauseResult<PersistableUpload> tryPause(boolean forceCancelTransfers) {
        return this.pause(forceCancelTransfers);
    }

    @Override
    public void abort() {
        UploadMonitor uploadMonitor = (UploadMonitor)this.monitor;
        uploadMonitor.performAbort();
    }

    @Override
    public boolean isResumeableMultipartUploadAfterFailed() {
        return this.isResumeableMultipartUploadAfterFailed;
    }

    @Override
    public PersistableUpload getResumeableMultipartUploadId() {
        if (this.isResumeableMultipartUploadAfterFailed) {
            return this.persistableUploadInfo;
        }
        return null;
    }

    PersistableUpload getPersistableUploadInfo() {
        return this.persistableUploadInfo;
    }

    void setPersistableUploadInfo(PersistableUpload persistableUploadInfo) {
        this.persistableUploadInfo = persistableUploadInfo;
    }

    void setResumeableMultipartUploadAfterFailed(boolean isResumeableMultipartUploadAfterFailed) {
        this.isResumeableMultipartUploadAfterFailed = isResumeableMultipartUploadAfterFailed;
    }
}

