/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.Grant;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.GroupGrantee;
import com.qcloud.cos.model.Owner;
import com.qcloud.cos.model.UinGrantee;

public class AclXmlFactory {
    public byte[] convertToXmlByteArray(AccessControlList acl) throws CosClientException {
        Owner owner = acl.getOwner();
        if (owner == null) {
            throw new CosClientException("Invalid AccessControlList: missing an COS Owner");
        }
        XmlWriter xml = new XmlWriter();
        xml.start("AccessControlPolicy");
        xml.start("Owner");
        if (owner.getId() != null) {
            xml.start("ID").value(owner.getId()).end();
        }
        if (owner.getDisplayName() != null) {
            xml.start("DisplayName").value(owner.getDisplayName()).end();
        }
        xml.end();
        xml.start("AccessControlList");
        for (Grant grant : acl.getGrantsAsList()) {
            xml.start("Grant");
            this.convertToXml(grant.getGrantee(), xml);
            xml.start("Permission").value(grant.getPermission().toString()).end();
            xml.end();
        }
        xml.end();
        xml.end();
        return xml.getBytes();
    }

    protected XmlWriter convertToXml(Grantee grantee, XmlWriter xml) throws CosClientException {
        if (grantee instanceof UinGrantee) {
            return this.convertToXml((UinGrantee)grantee, xml);
        }
        if (grantee instanceof GroupGrantee) {
            return this.convertToXml((GroupGrantee)grantee, xml);
        }
        throw new CosClientException("Unknown Grantee type: " + grantee.getClass().getName());
    }

    protected XmlWriter convertToXml(UinGrantee grantee, XmlWriter xml) {
        xml.start("Grantee", new String[]{"xmlns:xsi", "xsi:type"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "RootAccount"});
        xml.start("ID").value(grantee.getIdentifier()).end();
        xml.end();
        return xml;
    }

    protected XmlWriter convertToXml(GroupGrantee grantee, XmlWriter xml) {
        xml.start("Grantee", new String[]{"xmlns:xsi", "xsi:type"}, new String[]{"http://www.w3.org/2001/XMLSchema-instance", "Group"});
        xml.start("URI").value(grantee.getIdentifier()).end();
        xml.end();
        return xml;
    }
}

