/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.internal.COSXmlResponseHandler;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.HeaderHandler;
import com.qcloud.cos.internal.Unmarshaller;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

public class ResponseHeaderHandlerChain<T>
extends COSXmlResponseHandler<T> {
    private final List<HeaderHandler<T>> headerHandlers;

    public ResponseHeaderHandlerChain(Unmarshaller<T, InputStream> responseUnmarshaller, HeaderHandler<T> ... headerHandlers) {
        super(responseUnmarshaller);
        this.headerHandlers = Arrays.asList(headerHandlers);
    }

    @Override
    public CosServiceResponse<T> handle(CosHttpResponse response) throws Exception {
        Object cseResponse = super.handle(response);
        Object result = ((CosServiceResponse)cseResponse).getResult();
        if (result != null) {
            for (HeaderHandler handler : this.headerHandlers) {
                handler.handle(result, response);
            }
        }
        return cseResponse;
    }
}

