/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.endpoint.UserSpecifiedEndpointBuilder;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Download;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.Upload;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class UserSpecifiedEndpointDemo {
    private static String bucketName = "mybucket-12500000000";
    private static String key = "exampleobject";
    private static TransferManager transferManager = UserSpecifiedEndpointDemo.createTransferManager();

    public static void main(String[] args) {
        try {
            UserSpecifiedEndpointDemo.putObjectDemo();
            UserSpecifiedEndpointDemo.getObjectDemo();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            transferManager.shutdownNow();
        }
    }

    private static void putObjectDemo() {
        File localFile = new File("/path/to/localFile");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        try {
            Upload upload = transferManager.upload(putObjectRequest);
            UploadResult uploadResult = upload.waitForUploadResult();
            System.out.printf("RequestId : %s\n", uploadResult.getRequestId());
            System.out.println(uploadResult.getETag());
            System.out.println(uploadResult.getCrc64Ecma());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void getObjectDemo() {
        File downloadFile = new File("/path/to/downloadFile");
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        try {
            Download download = transferManager.download(getObjectRequest, downloadFile);
            download.waitForCompletion();
            System.out.printf("RequestId : %s\n", download.getObjectMetadata().getRequestId());
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static TransferManager createTransferManager() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("COS_REGION"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        UserSpecifiedEndpointBuilder endpointBuilder = new UserSpecifiedEndpointBuilder("generalApiEndpoint", "getServiceApiEndpoint");
        clientConfig.setEndpointBuilder(endpointBuilder);
        COSClient cosclient = new COSClient(cred, clientConfig);
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        return transferManager;
    }
}

