/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.ResponseHeaderOverrides;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.SSECustomerKeyProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GetObjectRequest
extends CosServiceRequest
implements SSECustomerKeyProvider,
Serializable {
    private String bucketName;
    private String key;
    private String versionId;
    private long[] range;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private ResponseHeaderOverrides responseHeaders;
    private SSECustomerKey sseCustomerKey;

    public GetObjectRequest(COSObjectId cosObjectId) {
        this(cosObjectId.getBucket(), cosObjectId.getKey(), cosObjectId.getVersionId());
    }

    public GetObjectRequest(String bucketName, String key) {
        this(bucketName, key, null);
    }

    public GetObjectRequest(String bucketName, String key, String versionId) {
        this.setBucketName(bucketName);
        this.setKey(key);
        this.setVersionId(versionId);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public GetObjectRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public GetObjectRequest withKey(String key) {
        this.setKey(key);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public GetObjectRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public long[] getRange() {
        return this.range;
    }

    public void setRange(long start, long end) {
        this.range = new long[]{start, end};
    }

    public GetObjectRequest withRange(long start, long end) {
        this.setRange(start, end);
        return this;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> eTagList) {
        this.matchingETagConstraints = eTagList;
    }

    public GetObjectRequest withMatchingETagConstraint(String eTag) {
        this.matchingETagConstraints.add(eTag);
        return this;
    }

    public List<String> getNonmatchingETagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingETagConstraints(List<String> eTagList) {
        this.nonmatchingEtagConstraints = eTagList;
    }

    public GetObjectRequest withNonmatchingETagConstraint(String eTag) {
        this.nonmatchingEtagConstraints.add(eTag);
        return this;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date date) {
        this.unmodifiedSinceConstraint = date;
    }

    public GetObjectRequest withUnmodifiedSinceConstraint(Date date) {
        this.setUnmodifiedSinceConstraint(date);
        return this;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date date) {
        this.modifiedSinceConstraint = date;
    }

    public GetObjectRequest withModifiedSinceConstraint(Date date) {
        this.setModifiedSinceConstraint(date);
        return this;
    }

    public ResponseHeaderOverrides getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(ResponseHeaderOverrides responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public GetObjectRequest withResponseHeaders(ResponseHeaderOverrides responseHeaders) {
        this.setResponseHeaders(responseHeaders);
        return this;
    }

    @Override
    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sseKey) {
        this.sseCustomerKey = sseKey;
    }

    public GetObjectRequest withSSECustomerKey(SSECustomerKey sseKey) {
        this.setSSECustomerKey(sseKey);
        return this;
    }

    public COSObjectId getCOSObjectId() {
        return new COSObjectId(this.bucketName, this.key, this.versionId);
    }
}

