/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.hadoop.fs.cosn.buffer.CosNByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CosNMappedBuffer
extends CosNByteBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(MappedByteBuffer.class);
    private File file;
    private RandomAccessFile randomAccessFile;

    public CosNMappedBuffer(ByteBuffer byteBuffer, RandomAccessFile randomAccessFile, File file) {
        super(byteBuffer);
        this.randomAccessFile = randomAccessFile;
        this.file = file;
    }

    @Override
    boolean isMapped() {
        return true;
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOException e = null;
        try {
            if (null != this.randomAccessFile) {
                this.randomAccessFile.close();
            }
        }
        catch (IOException e1) {
            LOG.error("Close the random access file failed.", (Throwable)e1);
            e = e1;
        }
        if (null != this.file && this.file.exists() && !this.file.delete()) {
            LOG.warn("Failed to clean up the temporary file: [{}].", (Object)this.file);
        }
        if (null != e) {
            throw e;
        }
    }
}

