/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResettableFileInputStream
extends InputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final String fileName;
    private int bufferSize;
    private InputStream inputStream;
    private long position;
    private long mark;
    private boolean isMarkSet;

    public ResettableFileInputStream(File file) throws IOException {
        this(file.getCanonicalPath());
    }

    public ResettableFileInputStream(String filename) throws IOException {
        this(filename, 1024);
    }

    public ResettableFileInputStream(String filename, int bufferSize) throws IOException {
        this.bufferSize = bufferSize;
        this.fileName = filename;
        this.position = 0L;
        this.inputStream = this.newStream();
    }

    @Override
    public void mark(int readLimit) {
        this.isMarkSet = true;
        this.mark = this.position;
        this.inputStream.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        if (!this.isMarkSet) {
            throw new IOException("Unmarked Stream");
        }
        try {
            this.inputStream.reset();
        }
        catch (IOException ioe) {
            try {
                this.inputStream.close();
                this.inputStream = this.newStream();
                this.inputStream.skip(this.mark);
                this.position = this.mark;
            }
            catch (Exception e) {
                throw new IOException("Cannot reset current Stream: " + e.getMessage());
            }
        }
    }

    protected InputStream newStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.fileName), this.bufferSize);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public int read() throws IOException {
        ++this.position;
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int count = this.inputStream.read(bytes, offset, length);
        this.position += (long)count;
        return count;
    }

    @Override
    public long skip(long count) throws IOException {
        this.position += count;
        return this.inputStream.skip(count);
    }
}

