/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.cosn.CrcUtil;

public class CRC32CCheckSum
extends FileChecksum {
    private static final String ALGORITHM_NAME = "COMPOSITE-CRC32C";
    private int crc32c = 0;

    public CRC32CCheckSum() {
    }

    public CRC32CCheckSum(String crc32cecma) {
        try {
            BigInteger bigInteger = new BigInteger(crc32cecma);
            this.crc32c = bigInteger.intValue();
        }
        catch (NumberFormatException e) {
            this.crc32c = 0;
        }
    }

    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    public int getLength() {
        return 4;
    }

    public byte[] getBytes() {
        return CrcUtil.intToBytes(this.crc32c);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.crc32c);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.crc32c = dataInput.readInt();
    }

    public String toString() {
        return this.getAlgorithmName() + ":" + String.format("0x%08x", this.crc32c);
    }
}

