/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.auth;

import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.utils.StringUtils;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.auth.AbstractCOSCredentialProvider;

public class EnvironmentVariableCredentialProvider
extends AbstractCOSCredentialProvider
implements COSCredentialsProvider {
    private String appId;

    public EnvironmentVariableCredentialProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
        if (null != conf) {
            this.appId = conf.get("fs.cosn.userinfo.appid");
        }
    }

    public COSCredentials getCredentials() {
        String secretId = System.getenv("COSN_SECRET_ID");
        String secretKey = System.getenv("COSN_SECRET_KEY");
        secretId = StringUtils.trim((String)secretId);
        secretKey = StringUtils.trim((String)secretKey);
        if (!StringUtils.isNullOrEmpty((String)secretId) && !StringUtils.isNullOrEmpty((String)secretKey)) {
            if (null != this.appId) {
                return new BasicCOSCredentials(this.appId, secretId, secretKey);
            }
            return new BasicCOSCredentials(secretId, secretKey);
        }
        return null;
    }

    public void refresh() {
    }

    public String toString() {
        return String.format("EnvironmentVariableCredentialProvider{%s, %s}", "COSN_SECRET_ID", "COSN_SECRET_KEY");
    }
}

