/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CosNFSInputStream;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosNFileReadTask
implements Runnable {
    static final Logger LOG = LoggerFactory.getLogger(CosNFileReadTask.class);
    private final String key;
    private final NativeFileSystemStore store;
    private final CosNFSInputStream.ReadBuffer readBuffer;

    public CosNFileReadTask(Configuration conf, String key, NativeFileSystemStore store, CosNFSInputStream.ReadBuffer readBuffer) {
        this.key = key;
        this.store = store;
        this.readBuffer = readBuffer;
    }

    @Override
    public void run() {
        try {
            this.readBuffer.lock();
            try {
                InputStream inputStream = this.store.retrieveBlock(this.key, this.readBuffer.getStart(), this.readBuffer.getEnd());
                IOUtils.readFully((InputStream)inputStream, (byte[])this.readBuffer.getBuffer(), (int)0, (int)this.readBuffer.getBuffer().length);
                int readEof = inputStream.read();
                if (readEof != -1) {
                    LOG.error("Expect to read the eof, but the return is not -1. key: {}.", (Object)this.key);
                }
                inputStream.close();
                this.readBuffer.setStatus(0);
            }
            catch (IOException e) {
                this.readBuffer.setStatus(-1);
                this.readBuffer.setException(e);
                LOG.error("Exception occurs when retrieve the block range start: " + String.valueOf(this.readBuffer.getStart()) + " end: " + this.readBuffer.getEnd(), (Throwable)e);
            }
            this.readBuffer.signalAll();
        }
        finally {
            this.readBuffer.unLock();
        }
    }
}

