/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import org.apache.commons.beanutils.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationUseStyleCheck
extends Check {
    private static final String ANNOTATION_ELEMENT_SINGLE_NAME = "value";
    private ElementStyle mStyle = ElementStyle.COMPACT_NO_ARRAY;
    private TrailingArrayComma mComma = TrailingArrayComma.NEVER;
    private ClosingParens mParens = ClosingParens.NEVER;

    public void setElementStyle(String aStyle) {
        this.mStyle = this.getOption(ElementStyle.class, aStyle);
    }

    public void setTrailingArrayComma(String aComma) {
        this.mComma = this.getOption(TrailingArrayComma.class, aComma);
    }

    public void setClosingParens(String aParens) {
        this.mParens = this.getOption(ClosingParens.class, aParens);
    }

    private <T extends Enum<T>> T getOption(Class<T> aEnumClass, String aString) {
        try {
            return Enum.valueOf(aEnumClass, aString.trim().toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + aString, (Throwable)iae);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{159};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST aAST) {
        this.checkStyleType(aAST);
        this.checkCheckClosingParens(aAST);
        this.checkTrailingComma(aAST);
    }

    private void checkStyleType(DetailAST aAnnotation) {
        if (ElementStyle.IGNORE.equals((Object)this.mStyle) || this.mStyle == null) {
            return;
        }
        if (ElementStyle.COMPACT_NO_ARRAY.equals((Object)this.mStyle)) {
            this.checkCompactNoArrayStyle(aAnnotation);
        } else if (ElementStyle.COMPACT.equals((Object)this.mStyle)) {
            this.checkCompactStyle(aAnnotation);
        } else if (ElementStyle.EXPANDED.equals((Object)this.mStyle)) {
            this.checkExpandedStyle(aAnnotation);
        }
    }

    private void checkExpandedStyle(DetailAST aAnnotation) {
        int valuePairCount = aAnnotation.getChildCount(160);
        if (valuePairCount == 0 && aAnnotation.branchContains(28)) {
            this.log(aAnnotation.getLineNo(), "annotation.incorrect.style", new Object[]{ElementStyle.EXPANDED});
        }
    }

    private void checkCompactStyle(DetailAST aAnnotation) {
        int valuePairCount = aAnnotation.getChildCount(160);
        DetailAST valuePair = aAnnotation.findFirstToken(160);
        if (valuePairCount == 1 && ANNOTATION_ELEMENT_SINGLE_NAME.equals(valuePair.getFirstChild().getText())) {
            this.log(aAnnotation.getLineNo(), "annotation.incorrect.style", new Object[]{ElementStyle.COMPACT});
        }
    }

    private void checkCompactNoArrayStyle(DetailAST aAnnotation) {
        DetailAST nestedArrayInit;
        DetailAST arrayInit = aAnnotation.findFirstToken(162);
        int valuePairCount = aAnnotation.getChildCount(160);
        DetailAST valuePair = aAnnotation.findFirstToken(160);
        if (arrayInit != null && arrayInit.getChildCount(28) == 1) {
            this.log(aAnnotation.getLineNo(), "annotation.incorrect.style", new Object[]{ElementStyle.COMPACT_NO_ARRAY});
        } else if (valuePairCount == 1 && (nestedArrayInit = valuePair.findFirstToken(162)) != null && ANNOTATION_ELEMENT_SINGLE_NAME.equals(valuePair.getFirstChild().getText()) && nestedArrayInit.getChildCount(28) == 1) {
            this.log(aAnnotation.getLineNo(), "annotation.incorrect.style", new Object[]{ElementStyle.COMPACT_NO_ARRAY});
        }
    }

    private void checkTrailingComma(DetailAST aAnnotation) {
        if (TrailingArrayComma.IGNORE.equals((Object)this.mComma) || this.mComma == null) {
            return;
        }
        for (DetailAST child = aAnnotation.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST arrayInit = null;
            if (child.getType() == 160) {
                arrayInit = child.findFirstToken(162);
            } else if (child.getType() == 162) {
                arrayInit = child;
            }
            if (arrayInit == null) continue;
            this.logCommaViolation(arrayInit);
        }
    }

    private void logCommaViolation(DetailAST aAST) {
        DetailAST rCurly = aAST.findFirstToken(73);
        DetailAST comma = rCurly.getPreviousSibling();
        if (TrailingArrayComma.ALWAYS.equals((Object)this.mComma) && (comma == null || comma.getType() != 74)) {
            this.log(rCurly.getLineNo(), rCurly.getColumnNo(), "annotation.trailing.comma.missing", new Object[0]);
        } else if (TrailingArrayComma.NEVER.equals((Object)this.mComma) && comma != null && comma.getType() == 74) {
            this.log(comma.getLineNo(), comma.getColumnNo(), "annotation.trailing.comma.present", new Object[0]);
        }
    }

    private void checkCheckClosingParens(DetailAST aAST) {
        boolean parenExists;
        if (ClosingParens.IGNORE.equals((Object)this.mParens) || this.mParens == null) {
            return;
        }
        DetailAST paren = aAST.getLastChild();
        boolean bl = parenExists = paren.getType() == 77;
        if (ClosingParens.ALWAYS.equals((Object)this.mParens) && !parenExists) {
            this.log(aAST.getLineNo(), "annotation.parens.missing", new Object[0]);
        } else if (ClosingParens.NEVER.equals((Object)this.mParens) && !aAST.branchContains(28) && parenExists) {
            this.log(aAST.getLineNo(), "annotation.parens.present", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClosingParens {
        ALWAYS,
        NEVER,
        IGNORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TrailingArrayComma {
        ALWAYS,
        NEVER,
        IGNORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ElementStyle {
        EXPANDED,
        COMPACT,
        COMPACT_NO_ARRAY,
        IGNORE;

    }
}

