/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultConfiguration
implements Configuration {
    private static final long serialVersionUID = 1157875385356127169L;
    private final String mName;
    private final List<Configuration> mChildren = Lists.newArrayList();
    private final Map<String, String> mAttributeMap = Maps.newHashMap();
    private final Map<String, String> mMessages = Maps.newHashMap();

    public DefaultConfiguration(String aName) {
        this.mName = aName;
    }

    @Override
    public String[] getAttributeNames() {
        Set<String> keySet = this.mAttributeMap.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    public String getAttribute(String aName) throws CheckstyleException {
        if (!this.mAttributeMap.containsKey(aName)) {
            throw new CheckstyleException("missing key '" + aName + "' in " + this.getName());
        }
        return this.mAttributeMap.get(aName);
    }

    @Override
    public Configuration[] getChildren() {
        return this.mChildren.toArray(new Configuration[this.mChildren.size()]);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void addChild(Configuration aConfiguration) {
        this.mChildren.add(aConfiguration);
    }

    public void removeChild(Configuration aConfiguration) {
        this.mChildren.remove(aConfiguration);
    }

    public void addAttribute(String aName, String aValue) {
        String current = this.mAttributeMap.put(aName, aValue);
        if (null == current) {
            this.mAttributeMap.put(aName, aValue);
        } else {
            this.mAttributeMap.put(aName, current + "," + aValue);
        }
    }

    public void addMessage(String aKey, String aValue) {
        this.mMessages.put(aKey, aValue);
    }

    @Override
    public ImmutableMap<String, String> getMessages() {
        return ImmutableMap.copyOf(this.mMessages);
    }
}

