/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.iterators.DescendantIterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;

public abstract class AbstractRootNode
extends AbstractNode {
    private static final String ROOT_NAME = "ROOT";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];

    protected AbstractRootNode() {
        super((TreeInfo)new GenericTreeInfo(Configuration.newConfiguration()));
    }

    public int compareOrder(NodeInfo nodeInfo) {
        throw AbstractRootNode.throwUnsupportedOperationException();
    }

    public String getAttributeValue(NamespaceUri namespace, String localPart) {
        throw AbstractRootNode.throwUnsupportedOperationException();
    }

    public String getLocalPart() {
        return ROOT_NAME;
    }

    public int getNodeKind() {
        return 9;
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public AxisIterator iterateAxis(int axisNumber) {
        return switch (axisNumber) {
            case 0, 6, 7, 9, 10, 11 -> EmptyIterator.ofNodes();
            case 1, 12 -> SingleNodeIterator.makeIterator((NodeInfo)this);
            case 3 -> {
                if (this.hasChildNodes()) {
                    yield new ArrayIterator.OfNodes((NodeInfo[])this.getChildren().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
                }
                yield EmptyIterator.ofNodes();
            }
            case 4 -> {
                if (this.hasChildNodes()) {
                    yield new DescendantIterator(this, DescendantIterator.StartWith.CHILDREN);
                }
                yield EmptyIterator.ofNodes();
            }
            case 5 -> new DescendantIterator(this, DescendantIterator.StartWith.CURRENT_NODE);
            default -> throw AbstractRootNode.throwUnsupportedOperationException();
        };
    }

    @Override
    public int getDepth() {
        return 0;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

