/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

@StatelessCheck
public class PatternVariableAssignmentCheck
extends AbstractCheck {
    public static final String MSG_KEY = "pattern.variable.assignment";
    private static final Set<Integer> ASSIGN_TOKEN_TYPES = Set.of(80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108);

    @Override
    public int[] getRequiredTokens() {
        return new int[]{121};
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        List<DetailAST> patternVariableIdents = PatternVariableAssignmentCheck.getPatternVariableIdents(ast);
        List<DetailAST> reassignedVariableIdents = PatternVariableAssignmentCheck.getReassignedVariableIdents(ast);
        block0: for (DetailAST patternVariableIdent : patternVariableIdents) {
            for (DetailAST assignTokenIdent : reassignedVariableIdents) {
                if (!patternVariableIdent.getText().equals(assignTokenIdent.getText())) continue;
                this.log(assignTokenIdent, MSG_KEY, assignTokenIdent.getText());
                continue block0;
            }
        }
    }

    private static List<DetailAST> getPatternVariableIdents(DetailAST ast) {
        DetailAST recordPatternComponents;
        DetailAST outermostPatternVariable = ast.findFirstToken(198);
        DetailAST recordPatternDef = ast.getType() == 121 ? ast.findFirstToken(215) : ast;
        ArrayList<DetailAST> patternVariableIdentsArray = new ArrayList<DetailAST>();
        if (outermostPatternVariable != null) {
            patternVariableIdentsArray.add(outermostPatternVariable.findFirstToken(58));
        } else if (recordPatternDef != null && (recordPatternComponents = recordPatternDef.findFirstToken(216)) != null) {
            for (DetailAST innerPatternVariable = recordPatternComponents.getFirstChild(); innerPatternVariable != null; innerPatternVariable = innerPatternVariable.getNextSibling()) {
                if (innerPatternVariable.getType() == 198) {
                    patternVariableIdentsArray.add(innerPatternVariable.findFirstToken(58));
                    continue;
                }
                patternVariableIdentsArray.addAll(PatternVariableAssignmentCheck.getPatternVariableIdents(innerPatternVariable));
            }
        }
        return patternVariableIdentsArray;
    }

    private static List<DetailAST> getReassignedVariableIdents(DetailAST ast) {
        DetailAST branchLeadingToReassignedVar = PatternVariableAssignmentCheck.getBranchLeadingToReassignedVars(ast);
        ArrayList<DetailAST> reassignedVariableIdents = new ArrayList<DetailAST>();
        DetailAST expressionBranch = branchLeadingToReassignedVar;
        while (expressionBranch != null) {
            DetailAST assignToken = PatternVariableAssignmentCheck.getMatchedAssignToken(expressionBranch);
            if (assignToken != null) {
                reassignedVariableIdents.add(PatternVariableAssignmentCheck.getNeededAssignIdent(assignToken));
            }
            expressionBranch = PatternVariableAssignmentCheck.traverseUntilNeededBranchType(expressionBranch, branchLeadingToReassignedVar, 28);
        }
        return reassignedVariableIdents;
    }

    @Nullable
    private static DetailAST getBranchLeadingToReassignedVars(DetailAST ast) {
        DetailAST leadingToReassignedVarBranch = null;
        for (DetailAST conditionalStatement = ast; conditionalStatement != null && leadingToReassignedVarBranch == null; conditionalStatement = conditionalStatement.getParent()) {
            if (conditionalStatement.getType() == 83 || conditionalStatement.getType() == 92) {
                leadingToReassignedVarBranch = conditionalStatement.findFirstToken(7);
                continue;
            }
            if (conditionalStatement.getType() != 109) continue;
            leadingToReassignedVarBranch = conditionalStatement;
        }
        return leadingToReassignedVarBranch;
    }

    @Nullable
    private static DetailAST traverseUntilNeededBranchType(DetailAST startingBranch, DetailAST bound, int neededTokenType) {
        DetailAST match = null;
        DetailAST iteratedBranch = PatternVariableAssignmentCheck.shiftToNextTraversedBranch(startingBranch, bound);
        while (iteratedBranch != null) {
            if (iteratedBranch.getType() == neededTokenType) {
                match = iteratedBranch;
                break;
            }
            iteratedBranch = PatternVariableAssignmentCheck.shiftToNextTraversedBranch(iteratedBranch, bound);
        }
        return match;
    }

    @Nullable
    private static DetailAST shiftToNextTraversedBranch(DetailAST ast, DetailAST boundAst) {
        DetailAST newAst = ast;
        if (ast.getFirstChild() != null) {
            newAst = ast.getFirstChild();
        } else {
            while (newAst.getNextSibling() == null && !newAst.equals(boundAst)) {
                newAst = newAst.getParent();
            }
            newAst = newAst.equals(boundAst) ? null : newAst.getNextSibling();
        }
        return newAst;
    }

    @Nullable
    private static DetailAST getMatchedAssignToken(DetailAST preAssignBranch) {
        int assignType;
        DetailAST matchedAssignToken = null;
        Iterator<Integer> iterator = ASSIGN_TOKEN_TYPES.iterator();
        while (iterator.hasNext() && (matchedAssignToken = preAssignBranch.findFirstToken(assignType = iterator.next().intValue())) == null) {
        }
        return matchedAssignToken;
    }

    private static DetailAST getNeededAssignIdent(DetailAST assignToken) {
        DetailAST assignIdent = assignToken;
        while (PatternVariableAssignmentCheck.traverseUntilNeededBranchType(assignIdent, assignToken.getFirstChild(), 58) != null) {
            assignIdent = PatternVariableAssignmentCheck.traverseUntilNeededBranchType(assignIdent, assignToken, 58);
        }
        return assignIdent;
    }
}

