/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.seq.spring.boot.autoconfigure.actuator;

import com.power4j.kit.seq.core.Sequence;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;

@Endpoint(id="sequence")
public class SequenceEndpoint
implements SmartInitializingSingleton {
    private final ApplicationContext applicationContext;
    private List<SequenceInfo> sequenceInfoList;

    public SequenceEndpoint(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        this.sequenceInfoList = this.applicationContext.getBeansOfType(Sequence.class).entrySet().stream().map(kv -> new SequenceInfo((String)kv.getKey(), ((Sequence)kv.getValue()).getClass().getName(), ((Sequence)kv.getValue()).getName())).collect(Collectors.toList());
    }

    @ReadOperation
    public List<SequenceInfo> sequenceBeans() {
        return this.sequenceInfoList;
    }

    public static class SequenceInfo {
        private final String beanName;
        private final String className;
        private final String seqName;

        public String getBeanName() {
            return this.beanName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSeqName() {
            return this.seqName;
        }

        public SequenceInfo(String beanName, String className, String seqName) {
            this.beanName = beanName;
            this.className = className;
            this.seqName = seqName;
        }
    }
}

