/*
 * Decompiled with CFR 0.152.
 */
package com.power4j.kit.seq.spring.boot.autoconfigure.actuator;

import com.power4j.kit.seq.persistent.SeqSynchronizer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;

@Endpoint(id="sequence-synchronizer")
public class SeqSynchronizerEndpoint
implements SmartInitializingSingleton {
    private final ApplicationContext applicationContext;
    private Map<String, SeqSynchronizer> synchronizerBeanMap;

    public SeqSynchronizerEndpoint(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        this.synchronizerBeanMap = this.applicationContext.getBeansOfType(SeqSynchronizer.class);
    }

    @ReadOperation
    public List<SynchronizerInfo> synchronizerInfo() {
        return this.synchronizerBeanMap.entrySet().stream().map(kv -> new SynchronizerInfo((String)kv.getKey(), ((SeqSynchronizer)kv.getValue()).getClass().getName(), ((SeqSynchronizer)kv.getValue()).getQueryCounter(), ((SeqSynchronizer)kv.getValue()).getUpdateCounter())).collect(Collectors.toList());
    }

    public static class SynchronizerInfo {
        private final String beanName;
        private final String className;
        private final Long queryCount;
        private final Long updateCount;

        public String getBeanName() {
            return this.beanName;
        }

        public String getClassName() {
            return this.className;
        }

        public Long getQueryCount() {
            return this.queryCount;
        }

        public Long getUpdateCount() {
            return this.updateCount;
        }

        public SynchronizerInfo(String beanName, String className, Long queryCount, Long updateCount) {
            this.beanName = beanName;
            this.className = className;
            this.queryCount = queryCount;
            this.updateCount = updateCount;
        }
    }
}

